package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{
  VpcId,
  Description,
  ResourceArn,
  ResourceId,
  ResourceName
}
import scala.jdk.CollectionConverters.*
final case class Firewall(
    firewallName: Option[ResourceName] = None,
    firewallArn: Option[ResourceArn] = None,
    firewallPolicyArn: ResourceArn,
    vpcId: VpcId,
    subnetMappings: Iterable[zio.aws.networkfirewall.model.SubnetMapping],
    deleteProtection: Option[Boolean] = None,
    subnetChangeProtection: Option[Boolean] = None,
    firewallPolicyChangeProtection: Option[Boolean] = None,
    description: Option[Description] = None,
    firewallId: ResourceId,
    tags: Option[Iterable[zio.aws.networkfirewall.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.Firewall = {
    import Firewall.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.Firewall
      .builder()
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .firewallPolicyArn(
        ResourceArn.unwrap(firewallPolicyArn): java.lang.String
      )
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .subnetMappings(subnetMappings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(deleteProtection.map(value => value: java.lang.Boolean))(
        _.deleteProtection
      )
      .optionallyWith(
        subnetChangeProtection.map(value => value: java.lang.Boolean)
      )(_.subnetChangeProtection)
      .optionallyWith(
        firewallPolicyChangeProtection.map(value => value: java.lang.Boolean)
      )(_.firewallPolicyChangeProtection)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .firewallId(ResourceId.unwrap(firewallId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.Firewall.ReadOnly =
    zio.aws.networkfirewall.model.Firewall.wrap(buildAwsValue())
}
object Firewall {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.Firewall
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.Firewall =
      zio.aws.networkfirewall.model.Firewall(
        firewallName.map(value => value),
        firewallArn.map(value => value),
        firewallPolicyArn,
        vpcId,
        subnetMappings.map { item =>
          item.asEditable
        },
        deleteProtection.map(value => value),
        subnetChangeProtection.map(value => value),
        firewallPolicyChangeProtection.map(value => value),
        description.map(value => value),
        firewallId,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def firewallName: Option[ResourceName]
    def firewallArn: Option[ResourceArn]
    def firewallPolicyArn: ResourceArn
    def vpcId: VpcId
    def subnetMappings
        : List[zio.aws.networkfirewall.model.SubnetMapping.ReadOnly]
    def deleteProtection: Option[Boolean]
    def subnetChangeProtection: Option[Boolean]
    def firewallPolicyChangeProtection: Option[Boolean]
    def description: Option[Description]
    def firewallId: ResourceId
    def tags: Option[List[zio.aws.networkfirewall.model.Tag.ReadOnly]]
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallPolicyArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(firewallPolicyArn)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getSubnetMappings: ZIO[Any, Nothing, List[
      zio.aws.networkfirewall.model.SubnetMapping.ReadOnly
    ]] = ZIO.succeed(subnetMappings)
    def getDeleteProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteProtection", deleteProtection)
    def getSubnetChangeProtection: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("subnetChangeProtection", subnetChangeProtection)
    def getFirewallPolicyChangeProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "firewallPolicyChangeProtection",
        firewallPolicyChangeProtection
      )
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getFirewallId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(firewallId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.Firewall
  ) extends zio.aws.networkfirewall.model.Firewall.ReadOnly {
    override val firewallName: Option[ResourceName] = scala
      .Option(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val firewallArn: Option[ResourceArn] = scala
      .Option(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallPolicyArn: ResourceArn =
      zio.aws.networkfirewall.model.primitives
        .ResourceArn(impl.firewallPolicyArn())
    override val vpcId: VpcId =
      zio.aws.networkfirewall.model.primitives.VpcId(impl.vpcId())
    override val subnetMappings
        : List[zio.aws.networkfirewall.model.SubnetMapping.ReadOnly] = impl
      .subnetMappings()
      .asScala
      .map { item =>
        zio.aws.networkfirewall.model.SubnetMapping.wrap(item)
      }
      .toList
    override val deleteProtection: Option[Boolean] =
      scala.Option(impl.deleteProtection()).map(value => value: Boolean)
    override val subnetChangeProtection: Option[Boolean] =
      scala.Option(impl.subnetChangeProtection()).map(value => value: Boolean)
    override val firewallPolicyChangeProtection: Option[Boolean] = scala
      .Option(impl.firewallPolicyChangeProtection())
      .map(value => value: Boolean)
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.networkfirewall.model.primitives.Description(value))
    override val firewallId: ResourceId =
      zio.aws.networkfirewall.model.primitives.ResourceId(impl.firewallId())
    override val tags
        : Option[List[zio.aws.networkfirewall.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.Firewall
  ): zio.aws.networkfirewall.model.Firewall.ReadOnly = new Wrapper(impl)
}
