package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{ResourceArn, ResourceName}
import scala.jdk.CollectionConverters.*
final case class FirewallPolicyMetadata(
    name: Option[ResourceName] = None,
    arn: Option[ResourceArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.FirewallPolicyMetadata = {
    import FirewallPolicyMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.FirewallPolicyMetadata
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.FirewallPolicyMetadata.ReadOnly =
    zio.aws.networkfirewall.model.FirewallPolicyMetadata.wrap(buildAwsValue())
}
object FirewallPolicyMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.FirewallPolicyMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.FirewallPolicyMetadata =
      zio.aws.networkfirewall.model.FirewallPolicyMetadata(
        name.map(value => value),
        arn.map(value => value)
      )
    def name: Option[ResourceName]
    def arn: Option[ResourceArn]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.FirewallPolicyMetadata
  ) extends zio.aws.networkfirewall.model.FirewallPolicyMetadata.ReadOnly {
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val arn: Option[ResourceArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.FirewallPolicyMetadata
  ): zio.aws.networkfirewall.model.FirewallPolicyMetadata.ReadOnly =
    new Wrapper(impl)
}
