package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.networkfirewall.model.primitives.UpdateToken
import scala.jdk.CollectionConverters.*
final case class UpdateRuleGroupResponse(
    updateToken: UpdateToken,
    ruleGroupResponse: zio.aws.networkfirewall.model.RuleGroupResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupResponse = {
    import UpdateRuleGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupResponse
      .builder()
      .updateToken(UpdateToken.unwrap(updateToken): java.lang.String)
      .ruleGroupResponse(ruleGroupResponse.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.UpdateRuleGroupResponse.ReadOnly =
    zio.aws.networkfirewall.model.UpdateRuleGroupResponse.wrap(buildAwsValue())
}
object UpdateRuleGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.UpdateRuleGroupResponse =
      zio.aws.networkfirewall.model
        .UpdateRuleGroupResponse(updateToken, ruleGroupResponse.asEditable)
    def updateToken: UpdateToken
    def ruleGroupResponse
        : zio.aws.networkfirewall.model.RuleGroupResponse.ReadOnly
    def getUpdateToken: ZIO[Any, Nothing, UpdateToken] =
      ZIO.succeed(updateToken)
    def getRuleGroupResponse: ZIO[
      Any,
      Nothing,
      zio.aws.networkfirewall.model.RuleGroupResponse.ReadOnly
    ] = ZIO.succeed(ruleGroupResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupResponse
  ) extends zio.aws.networkfirewall.model.UpdateRuleGroupResponse.ReadOnly {
    override val updateToken: UpdateToken =
      zio.aws.networkfirewall.model.primitives.UpdateToken(impl.updateToken())
    override val ruleGroupResponse
        : zio.aws.networkfirewall.model.RuleGroupResponse.ReadOnly =
      zio.aws.networkfirewall.model.RuleGroupResponse
        .wrap(impl.ruleGroupResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupResponse
  ): zio.aws.networkfirewall.model.UpdateRuleGroupResponse.ReadOnly =
    new Wrapper(impl)
}
