package zio.aws.networkfirewall.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{
  PaginationMaxResults,
  VpcId,
  PaginationToken
}
import scala.jdk.CollectionConverters.*
final case class ListFirewallsRequest(
    nextToken: Option[PaginationToken] = None,
    vpcIds: Option[Iterable[VpcId]] = None,
    maxResults: Option[PaginationMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest = {
    import ListFirewallsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        vpcIds.map(value =>
          value.map { item =>
            VpcId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.vpcIds)
      .optionallyWith(
        maxResults.map(value => PaginationMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.ListFirewallsRequest.ReadOnly =
    zio.aws.networkfirewall.model.ListFirewallsRequest.wrap(buildAwsValue())
}
object ListFirewallsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.ListFirewallsRequest =
      zio.aws.networkfirewall.model.ListFirewallsRequest(
        nextToken.map(value => value),
        vpcIds.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[PaginationToken]
    def vpcIds: Option[List[VpcId]]
    def maxResults: Option[PaginationMaxResults]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVpcIds: ZIO[Any, AwsError, List[VpcId]] =
      AwsError.unwrapOptionField("vpcIds", vpcIds)
    def getMaxResults: ZIO[Any, AwsError, PaginationMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest
  ) extends zio.aws.networkfirewall.model.ListFirewallsRequest.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.PaginationToken(value)
      )
    override val vpcIds: Option[List[VpcId]] = scala
      .Option(impl.vpcIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.primitives.VpcId(item)
        }.toList
      )
    override val maxResults: Option[PaginationMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.PaginationMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest
  ): zio.aws.networkfirewall.model.ListFirewallsRequest.ReadOnly = new Wrapper(
    impl
  )
}
