package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{ResourceArn, ResourceName}
import scala.jdk.CollectionConverters.*
final case class DescribeRuleGroupMetadataRequest(
    ruleGroupName: Option[ResourceName] = None,
    ruleGroupArn: Option[ResourceArn] = None,
    `type`: Option[zio.aws.networkfirewall.model.RuleGroupType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataRequest = {
    import DescribeRuleGroupMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataRequest
      .builder()
      .optionallyWith(
        ruleGroupName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.ruleGroupName)
      .optionallyWith(
        ruleGroupArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.ruleGroupArn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DescribeRuleGroupMetadataRequest.ReadOnly =
    zio.aws.networkfirewall.model.DescribeRuleGroupMetadataRequest
      .wrap(buildAwsValue())
}
object DescribeRuleGroupMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.DescribeRuleGroupMetadataRequest =
      zio.aws.networkfirewall.model.DescribeRuleGroupMetadataRequest(
        ruleGroupName.map(value => value),
        ruleGroupArn.map(value => value),
        `type`.map(value => value)
      )
    def ruleGroupName: Option[ResourceName]
    def ruleGroupArn: Option[ResourceArn]
    def `type`: Option[zio.aws.networkfirewall.model.RuleGroupType]
    def getRuleGroupName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("ruleGroupName", ruleGroupName)
    def getRuleGroupArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("ruleGroupArn", ruleGroupArn)
    def getType
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.RuleGroupType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataRequest
  ) extends zio.aws.networkfirewall.model.DescribeRuleGroupMetadataRequest.ReadOnly {
    override val ruleGroupName: Option[ResourceName] = scala
      .Option(impl.ruleGroupName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val ruleGroupArn: Option[ResourceArn] = scala
      .Option(impl.ruleGroupArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val `type`: Option[zio.aws.networkfirewall.model.RuleGroupType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.networkfirewall.model.RuleGroupType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataRequest
  ): zio.aws.networkfirewall.model.DescribeRuleGroupMetadataRequest.ReadOnly =
    new Wrapper(impl)
}
