package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{ResourceName, ResourceArn}
import scala.jdk.CollectionConverters.*
final case class UpdateLoggingConfigurationRequest(
    firewallArn: Option[ResourceArn] = None,
    firewallName: Option[ResourceName] = None,
    loggingConfiguration: Option[
      zio.aws.networkfirewall.model.LoggingConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationRequest = {
    import UpdateLoggingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationRequest
      .builder()
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.UpdateLoggingConfigurationRequest.ReadOnly =
    zio.aws.networkfirewall.model.UpdateLoggingConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateLoggingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.UpdateLoggingConfigurationRequest =
      zio.aws.networkfirewall.model.UpdateLoggingConfigurationRequest(
        firewallArn.map(value => value),
        firewallName.map(value => value),
        loggingConfiguration.map(value => value.asEditable)
      )
    def firewallArn: Option[ResourceArn]
    def firewallName: Option[ResourceName]
    def loggingConfiguration
        : Option[zio.aws.networkfirewall.model.LoggingConfiguration.ReadOnly]
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.LoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationRequest
  ) extends zio.aws.networkfirewall.model.UpdateLoggingConfigurationRequest.ReadOnly {
    override val firewallArn: Option[ResourceArn] = scala
      .Option(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallName: Option[ResourceName] = scala
      .Option(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val loggingConfiguration
        : Option[zio.aws.networkfirewall.model.LoggingConfiguration.ReadOnly] =
      scala
        .Option(impl.loggingConfiguration())
        .map(value =>
          zio.aws.networkfirewall.model.LoggingConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationRequest
  ): zio.aws.networkfirewall.model.UpdateLoggingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
