package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StatefulEngineOptions(
    ruleOrder: Option[zio.aws.networkfirewall.model.RuleOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.StatefulEngineOptions = {
    import StatefulEngineOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.StatefulEngineOptions
      .builder()
      .optionallyWith(ruleOrder.map(value => value.unwrap))(_.ruleOrder)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.StatefulEngineOptions.ReadOnly =
    zio.aws.networkfirewall.model.StatefulEngineOptions.wrap(buildAwsValue())
}
object StatefulEngineOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.StatefulEngineOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.StatefulEngineOptions =
      zio.aws.networkfirewall.model
        .StatefulEngineOptions(ruleOrder.map(value => value))
    def ruleOrder: Option[zio.aws.networkfirewall.model.RuleOrder]
    def getRuleOrder
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.RuleOrder] =
      AwsError.unwrapOptionField("ruleOrder", ruleOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.StatefulEngineOptions
  ) extends zio.aws.networkfirewall.model.StatefulEngineOptions.ReadOnly {
    override val ruleOrder: Option[zio.aws.networkfirewall.model.RuleOrder] =
      scala
        .Option(impl.ruleOrder())
        .map(value => zio.aws.networkfirewall.model.RuleOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.StatefulEngineOptions
  ): zio.aws.networkfirewall.model.StatefulEngineOptions.ReadOnly = new Wrapper(
    impl
  )
}
