package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{
  UpdateToken,
  Description,
  ResourceName,
  ResourceArn
}
import scala.jdk.CollectionConverters.*
final case class UpdateFirewallDescriptionResponse(
    firewallArn: Option[ResourceArn] = None,
    firewallName: Option[ResourceName] = None,
    description: Option[Description] = None,
    updateToken: Option[UpdateToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionResponse = {
    import UpdateFirewallDescriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionResponse
      .builder()
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        updateToken.map(value => UpdateToken.unwrap(value): java.lang.String)
      )(_.updateToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.UpdateFirewallDescriptionResponse.ReadOnly =
    zio.aws.networkfirewall.model.UpdateFirewallDescriptionResponse
      .wrap(buildAwsValue())
}
object UpdateFirewallDescriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.UpdateFirewallDescriptionResponse =
      zio.aws.networkfirewall.model.UpdateFirewallDescriptionResponse(
        firewallArn.map(value => value),
        firewallName.map(value => value),
        description.map(value => value),
        updateToken.map(value => value)
      )
    def firewallArn: Option[ResourceArn]
    def firewallName: Option[ResourceName]
    def description: Option[Description]
    def updateToken: Option[UpdateToken]
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("updateToken", updateToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionResponse
  ) extends zio.aws.networkfirewall.model.UpdateFirewallDescriptionResponse.ReadOnly {
    override val firewallArn: Option[ResourceArn] = scala
      .Option(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallName: Option[ResourceName] = scala
      .Option(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.networkfirewall.model.primitives.Description(value))
    override val updateToken: Option[UpdateToken] = scala
      .Option(impl.updateToken())
      .map(value => zio.aws.networkfirewall.model.primitives.UpdateToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionResponse
  ): zio.aws.networkfirewall.model.UpdateFirewallDescriptionResponse.ReadOnly =
    new Wrapper(impl)
}
