package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class LoggingConfiguration(
    logDestinationConfigs: Iterable[
      zio.aws.networkfirewall.model.LogDestinationConfig
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.LoggingConfiguration = {
    import LoggingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.LoggingConfiguration
      .builder()
      .logDestinationConfigs(logDestinationConfigs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.LoggingConfiguration.ReadOnly =
    zio.aws.networkfirewall.model.LoggingConfiguration.wrap(buildAwsValue())
}
object LoggingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.LoggingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.LoggingConfiguration =
      zio.aws.networkfirewall.model
        .LoggingConfiguration(logDestinationConfigs.map { item =>
          item.asEditable
        })
    def logDestinationConfigs
        : List[zio.aws.networkfirewall.model.LogDestinationConfig.ReadOnly]
    def getLogDestinationConfigs: ZIO[Any, Nothing, List[
      zio.aws.networkfirewall.model.LogDestinationConfig.ReadOnly
    ]] = ZIO.succeed(logDestinationConfigs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.LoggingConfiguration
  ) extends zio.aws.networkfirewall.model.LoggingConfiguration.ReadOnly {
    override val logDestinationConfigs
        : List[zio.aws.networkfirewall.model.LogDestinationConfig.ReadOnly] =
      impl
        .logDestinationConfigs()
        .asScala
        .map { item =>
          zio.aws.networkfirewall.model.LogDestinationConfig.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.LoggingConfiguration
  ): zio.aws.networkfirewall.model.LoggingConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
