package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.UpdateToken
import scala.jdk.CollectionConverters.*
final case class DescribeFirewallResponse(
    updateToken: Option[UpdateToken] = None,
    firewall: Option[zio.aws.networkfirewall.model.Firewall] = None,
    firewallStatus: Option[zio.aws.networkfirewall.model.FirewallStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallResponse = {
    import DescribeFirewallResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallResponse
      .builder()
      .optionallyWith(
        updateToken.map(value => UpdateToken.unwrap(value): java.lang.String)
      )(_.updateToken)
      .optionallyWith(firewall.map(value => value.buildAwsValue()))(_.firewall)
      .optionallyWith(firewallStatus.map(value => value.buildAwsValue()))(
        _.firewallStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DescribeFirewallResponse.ReadOnly =
    zio.aws.networkfirewall.model.DescribeFirewallResponse.wrap(buildAwsValue())
}
object DescribeFirewallResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.DescribeFirewallResponse =
      zio.aws.networkfirewall.model.DescribeFirewallResponse(
        updateToken.map(value => value),
        firewall.map(value => value.asEditable),
        firewallStatus.map(value => value.asEditable)
      )
    def updateToken: Option[UpdateToken]
    def firewall: Option[zio.aws.networkfirewall.model.Firewall.ReadOnly]
    def firewallStatus
        : Option[zio.aws.networkfirewall.model.FirewallStatus.ReadOnly]
    def getUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("updateToken", updateToken)
    def getFirewall
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.Firewall.ReadOnly] =
      AwsError.unwrapOptionField("firewall", firewall)
    def getFirewallStatus: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.FirewallStatus.ReadOnly
    ] = AwsError.unwrapOptionField("firewallStatus", firewallStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallResponse
  ) extends zio.aws.networkfirewall.model.DescribeFirewallResponse.ReadOnly {
    override val updateToken: Option[UpdateToken] = scala
      .Option(impl.updateToken())
      .map(value => zio.aws.networkfirewall.model.primitives.UpdateToken(value))
    override val firewall
        : Option[zio.aws.networkfirewall.model.Firewall.ReadOnly] = scala
      .Option(impl.firewall())
      .map(value => zio.aws.networkfirewall.model.Firewall.wrap(value))
    override val firewallStatus
        : Option[zio.aws.networkfirewall.model.FirewallStatus.ReadOnly] = scala
      .Option(impl.firewallStatus())
      .map(value => zio.aws.networkfirewall.model.FirewallStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallResponse
  ): zio.aws.networkfirewall.model.DescribeFirewallResponse.ReadOnly =
    new Wrapper(impl)
}
