package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters.*
sealed trait ConfigurationSyncState {
  def unwrap: software.amazon.awssdk.services.networkfirewall.model.ConfigurationSyncState
}
object ConfigurationSyncState {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.ConfigurationSyncState
  ): zio.aws.networkfirewall.model.ConfigurationSyncState = value match {
    case software.amazon.awssdk.services.networkfirewall.model.ConfigurationSyncState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.ConfigurationSyncState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.networkfirewall.model.ConfigurationSyncState.IN_SYNC =>
      val r = IN_SYNC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.ConfigurationSyncState {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.ConfigurationSyncState =
      software.amazon.awssdk.services.networkfirewall.model.ConfigurationSyncState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING
      extends zio.aws.networkfirewall.model.ConfigurationSyncState {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.ConfigurationSyncState =
      software.amazon.awssdk.services.networkfirewall.model.ConfigurationSyncState.PENDING
  }
  case object IN_SYNC
      extends zio.aws.networkfirewall.model.ConfigurationSyncState {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.ConfigurationSyncState =
      software.amazon.awssdk.services.networkfirewall.model.ConfigurationSyncState.IN_SYNC
  }
}
