package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{EndpointId, AzSubnet}
import scala.jdk.CollectionConverters.*
final case class Attachment(
    subnetId: Option[AzSubnet] = None,
    endpointId: Option[EndpointId] = None,
    status: Option[zio.aws.networkfirewall.model.AttachmentStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.Attachment = {
    import Attachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.Attachment
      .builder()
      .optionallyWith(
        subnetId.map(value => AzSubnet.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        endpointId.map(value => EndpointId.unwrap(value): java.lang.String)
      )(_.endpointId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.Attachment.ReadOnly =
    zio.aws.networkfirewall.model.Attachment.wrap(buildAwsValue())
}
object Attachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.Attachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.Attachment =
      zio.aws.networkfirewall.model.Attachment(
        subnetId.map(value => value),
        endpointId.map(value => value),
        status.map(value => value)
      )
    def subnetId: Option[AzSubnet]
    def endpointId: Option[EndpointId]
    def status: Option[zio.aws.networkfirewall.model.AttachmentStatus]
    def getSubnetId: ZIO[Any, AwsError, AzSubnet] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getEndpointId: ZIO[Any, AwsError, EndpointId] =
      AwsError.unwrapOptionField("endpointId", endpointId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.AttachmentStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.Attachment
  ) extends zio.aws.networkfirewall.model.Attachment.ReadOnly {
    override val subnetId: Option[AzSubnet] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.networkfirewall.model.primitives.AzSubnet(value))
    override val endpointId: Option[EndpointId] = scala
      .Option(impl.endpointId())
      .map(value => zio.aws.networkfirewall.model.primitives.EndpointId(value))
    override val status
        : Option[zio.aws.networkfirewall.model.AttachmentStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.networkfirewall.model.AttachmentStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.Attachment
  ): zio.aws.networkfirewall.model.Attachment.ReadOnly = new Wrapper(impl)
}
