package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{
  RulesString,
  UpdateToken,
  Description,
  ResourceArn,
  ResourceName
}
import scala.jdk.CollectionConverters.*
final case class UpdateRuleGroupRequest(
    updateToken: UpdateToken,
    ruleGroupArn: Option[ResourceArn] = None,
    ruleGroupName: Option[ResourceName] = None,
    ruleGroup: Option[zio.aws.networkfirewall.model.RuleGroup] = None,
    rules: Option[RulesString] = None,
    `type`: Option[zio.aws.networkfirewall.model.RuleGroupType] = None,
    description: Option[Description] = None,
    dryRun: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupRequest = {
    import UpdateRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupRequest
      .builder()
      .updateToken(UpdateToken.unwrap(updateToken): java.lang.String)
      .optionallyWith(
        ruleGroupArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.ruleGroupArn)
      .optionallyWith(
        ruleGroupName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.ruleGroupName)
      .optionallyWith(ruleGroup.map(value => value.buildAwsValue()))(
        _.ruleGroup
      )
      .optionallyWith(
        rules.map(value => RulesString.unwrap(value): java.lang.String)
      )(_.rules)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.UpdateRuleGroupRequest.ReadOnly =
    zio.aws.networkfirewall.model.UpdateRuleGroupRequest.wrap(buildAwsValue())
}
object UpdateRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.UpdateRuleGroupRequest =
      zio.aws.networkfirewall.model.UpdateRuleGroupRequest(
        updateToken,
        ruleGroupArn.map(value => value),
        ruleGroupName.map(value => value),
        ruleGroup.map(value => value.asEditable),
        rules.map(value => value),
        `type`.map(value => value),
        description.map(value => value),
        dryRun.map(value => value)
      )
    def updateToken: UpdateToken
    def ruleGroupArn: Option[ResourceArn]
    def ruleGroupName: Option[ResourceName]
    def ruleGroup: Option[zio.aws.networkfirewall.model.RuleGroup.ReadOnly]
    def rules: Option[RulesString]
    def `type`: Option[zio.aws.networkfirewall.model.RuleGroupType]
    def description: Option[Description]
    def dryRun: Option[Boolean]
    def getUpdateToken: ZIO[Any, Nothing, UpdateToken] =
      ZIO.succeed(updateToken)
    def getRuleGroupArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("ruleGroupArn", ruleGroupArn)
    def getRuleGroupName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("ruleGroupName", ruleGroupName)
    def getRuleGroup
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.RuleGroup.ReadOnly] =
      AwsError.unwrapOptionField("ruleGroup", ruleGroup)
    def getRules: ZIO[Any, AwsError, RulesString] =
      AwsError.unwrapOptionField("rules", rules)
    def getType
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.RuleGroupType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupRequest
  ) extends zio.aws.networkfirewall.model.UpdateRuleGroupRequest.ReadOnly {
    override val updateToken: UpdateToken =
      zio.aws.networkfirewall.model.primitives.UpdateToken(impl.updateToken())
    override val ruleGroupArn: Option[ResourceArn] = scala
      .Option(impl.ruleGroupArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val ruleGroupName: Option[ResourceName] = scala
      .Option(impl.ruleGroupName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val ruleGroup
        : Option[zio.aws.networkfirewall.model.RuleGroup.ReadOnly] = scala
      .Option(impl.ruleGroup())
      .map(value => zio.aws.networkfirewall.model.RuleGroup.wrap(value))
    override val rules: Option[RulesString] = scala
      .Option(impl.rules())
      .map(value => zio.aws.networkfirewall.model.primitives.RulesString(value))
    override val `type`: Option[zio.aws.networkfirewall.model.RuleGroupType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.networkfirewall.model.RuleGroupType.wrap(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.networkfirewall.model.primitives.Description(value))
    override val dryRun: Option[Boolean] =
      scala.Option(impl.dryRun()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupRequest
  ): zio.aws.networkfirewall.model.UpdateRuleGroupRequest.ReadOnly =
    new Wrapper(impl)
}
