package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.networkfirewall.model.primitives.ResourceArn
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: ResourceArn,
    tags: Iterable[zio.aws.networkfirewall.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.TagResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.TagResourceRequest.ReadOnly =
    zio.aws.networkfirewall.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.TagResourceRequest =
      zio.aws.networkfirewall.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: ResourceArn
    def tags: List[zio.aws.networkfirewall.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.TagResourceRequest
  ) extends zio.aws.networkfirewall.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.networkfirewall.model.primitives.ResourceArn(impl.resourceArn())
    override val tags: List[zio.aws.networkfirewall.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.networkfirewall.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.TagResourceRequest
  ): zio.aws.networkfirewall.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
