package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{
  ResourceName,
  ResourceArn,
  UpdateToken
}
import scala.jdk.CollectionConverters.*
final case class UpdateFirewallPolicyChangeProtectionRequest(
    updateToken: Option[UpdateToken] = None,
    firewallArn: Option[ResourceArn] = None,
    firewallName: Option[ResourceName] = None,
    firewallPolicyChangeProtection: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest = {
    import UpdateFirewallPolicyChangeProtectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest
      .builder()
      .optionallyWith(
        updateToken.map(value => UpdateToken.unwrap(value): java.lang.String)
      )(_.updateToken)
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .firewallPolicyChangeProtection(
        firewallPolicyChangeProtection: java.lang.Boolean
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest.ReadOnly =
    zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest
      .wrap(buildAwsValue())
}
object UpdateFirewallPolicyChangeProtectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest =
      zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest(
        updateToken.map(value => value),
        firewallArn.map(value => value),
        firewallName.map(value => value),
        firewallPolicyChangeProtection
      )
    def updateToken: Option[UpdateToken]
    def firewallArn: Option[ResourceArn]
    def firewallName: Option[ResourceName]
    def firewallPolicyChangeProtection: Boolean
    def getUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("updateToken", updateToken)
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getFirewallPolicyChangeProtection: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(firewallPolicyChangeProtection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest
  ) extends zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest.ReadOnly {
    override val updateToken: Option[UpdateToken] = scala
      .Option(impl.updateToken())
      .map(value => zio.aws.networkfirewall.model.primitives.UpdateToken(value))
    override val firewallArn: Option[ResourceArn] = scala
      .Option(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallName: Option[ResourceName] = scala
      .Option(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val firewallPolicyChangeProtection: Boolean =
      impl.firewallPolicyChangeProtection(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest
  ): zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest.ReadOnly =
    new Wrapper(impl)
}
