package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceStatus {
  def unwrap
      : software.amazon.awssdk.services.networkfirewall.model.ResourceStatus
}
object ResourceStatus {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.ResourceStatus
  ): zio.aws.networkfirewall.model.ResourceStatus = value match {
    case software.amazon.awssdk.services.networkfirewall.model.ResourceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.ResourceStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.networkfirewall.model.ResourceStatus.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.ResourceStatus =
      software.amazon.awssdk.services.networkfirewall.model.ResourceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.networkfirewall.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.ResourceStatus =
      software.amazon.awssdk.services.networkfirewall.model.ResourceStatus.ACTIVE
  }
  case object DELETING extends zio.aws.networkfirewall.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.ResourceStatus =
      software.amazon.awssdk.services.networkfirewall.model.ResourceStatus.DELETING
  }
}
