package zio.aws.networkfirewall.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{
  PaginationMaxResults,
  PaginationToken
}
import scala.jdk.CollectionConverters.*
final case class ListFirewallPoliciesRequest(
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[PaginationMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest = {
    import ListFirewallPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => PaginationMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.ListFirewallPoliciesRequest.ReadOnly =
    zio.aws.networkfirewall.model.ListFirewallPoliciesRequest
      .wrap(buildAwsValue())
}
object ListFirewallPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.ListFirewallPoliciesRequest =
      zio.aws.networkfirewall.model.ListFirewallPoliciesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[PaginationToken]
    def maxResults: Option[PaginationMaxResults]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PaginationMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest
  ) extends zio.aws.networkfirewall.model.ListFirewallPoliciesRequest.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.PaginationToken(value)
      )
    override val maxResults: Option[PaginationMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.PaginationMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest
  ): zio.aws.networkfirewall.model.ListFirewallPoliciesRequest.ReadOnly =
    new Wrapper(impl)
}
