package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.UpdateToken
import scala.jdk.CollectionConverters.*
final case class DescribeRuleGroupResponse(
    updateToken: UpdateToken,
    ruleGroup: Option[zio.aws.networkfirewall.model.RuleGroup] = None,
    ruleGroupResponse: zio.aws.networkfirewall.model.RuleGroupResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupResponse = {
    import DescribeRuleGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupResponse
      .builder()
      .updateToken(UpdateToken.unwrap(updateToken): java.lang.String)
      .optionallyWith(ruleGroup.map(value => value.buildAwsValue()))(
        _.ruleGroup
      )
      .ruleGroupResponse(ruleGroupResponse.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DescribeRuleGroupResponse.ReadOnly =
    zio.aws.networkfirewall.model.DescribeRuleGroupResponse
      .wrap(buildAwsValue())
}
object DescribeRuleGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.DescribeRuleGroupResponse =
      zio.aws.networkfirewall.model.DescribeRuleGroupResponse(
        updateToken,
        ruleGroup.map(value => value.asEditable),
        ruleGroupResponse.asEditable
      )
    def updateToken: UpdateToken
    def ruleGroup: Option[zio.aws.networkfirewall.model.RuleGroup.ReadOnly]
    def ruleGroupResponse
        : zio.aws.networkfirewall.model.RuleGroupResponse.ReadOnly
    def getUpdateToken: ZIO[Any, Nothing, UpdateToken] =
      ZIO.succeed(updateToken)
    def getRuleGroup
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.RuleGroup.ReadOnly] =
      AwsError.unwrapOptionField("ruleGroup", ruleGroup)
    def getRuleGroupResponse: ZIO[
      Any,
      Nothing,
      zio.aws.networkfirewall.model.RuleGroupResponse.ReadOnly
    ] = ZIO.succeed(ruleGroupResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupResponse
  ) extends zio.aws.networkfirewall.model.DescribeRuleGroupResponse.ReadOnly {
    override val updateToken: UpdateToken =
      zio.aws.networkfirewall.model.primitives.UpdateToken(impl.updateToken())
    override val ruleGroup
        : Option[zio.aws.networkfirewall.model.RuleGroup.ReadOnly] = scala
      .Option(impl.ruleGroup())
      .map(value => zio.aws.networkfirewall.model.RuleGroup.wrap(value))
    override val ruleGroupResponse
        : zio.aws.networkfirewall.model.RuleGroupResponse.ReadOnly =
      zio.aws.networkfirewall.model.RuleGroupResponse
        .wrap(impl.ruleGroupResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupResponse
  ): zio.aws.networkfirewall.model.DescribeRuleGroupResponse.ReadOnly =
    new Wrapper(impl)
}
