package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{
  ResourceName,
  ResourceArn,
  UpdateToken
}
import scala.jdk.CollectionConverters.*
final case class UpdateFirewallPolicyChangeProtectionResponse(
    updateToken: Option[UpdateToken] = None,
    firewallArn: Option[ResourceArn] = None,
    firewallName: Option[ResourceName] = None,
    firewallPolicyChangeProtection: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse = {
    import UpdateFirewallPolicyChangeProtectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse
      .builder()
      .optionallyWith(
        updateToken.map(value => UpdateToken.unwrap(value): java.lang.String)
      )(_.updateToken)
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .optionallyWith(
        firewallPolicyChangeProtection.map(value => value: java.lang.Boolean)
      )(_.firewallPolicyChangeProtection)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse.ReadOnly =
    zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse
      .wrap(buildAwsValue())
}
object UpdateFirewallPolicyChangeProtectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse =
      zio.aws.networkfirewall.model
        .UpdateFirewallPolicyChangeProtectionResponse(
          updateToken.map(value => value),
          firewallArn.map(value => value),
          firewallName.map(value => value),
          firewallPolicyChangeProtection.map(value => value)
        )
    def updateToken: Option[UpdateToken]
    def firewallArn: Option[ResourceArn]
    def firewallName: Option[ResourceName]
    def firewallPolicyChangeProtection: Option[Boolean]
    def getUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("updateToken", updateToken)
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getFirewallPolicyChangeProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "firewallPolicyChangeProtection",
        firewallPolicyChangeProtection
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse
  ) extends zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse.ReadOnly {
    override val updateToken: Option[UpdateToken] = scala
      .Option(impl.updateToken())
      .map(value => zio.aws.networkfirewall.model.primitives.UpdateToken(value))
    override val firewallArn: Option[ResourceArn] = scala
      .Option(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallName: Option[ResourceName] = scala
      .Option(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val firewallPolicyChangeProtection: Option[Boolean] = scala
      .Option(impl.firewallPolicyChangeProtection())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse
  ): zio.aws.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse.ReadOnly =
    new Wrapper(impl)
}
