package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StatefulRuleOptions(
    ruleOrder: Option[zio.aws.networkfirewall.model.RuleOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleOptions = {
    import StatefulRuleOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.StatefulRuleOptions
      .builder()
      .optionallyWith(ruleOrder.map(value => value.unwrap))(_.ruleOrder)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.StatefulRuleOptions.ReadOnly =
    zio.aws.networkfirewall.model.StatefulRuleOptions.wrap(buildAwsValue())
}
object StatefulRuleOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.StatefulRuleOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.StatefulRuleOptions =
      zio.aws.networkfirewall.model
        .StatefulRuleOptions(ruleOrder.map(value => value))
    def ruleOrder: Option[zio.aws.networkfirewall.model.RuleOrder]
    def getRuleOrder
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.RuleOrder] =
      AwsError.unwrapOptionField("ruleOrder", ruleOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.StatefulRuleOptions
  ) extends zio.aws.networkfirewall.model.StatefulRuleOptions.ReadOnly {
    override val ruleOrder: Option[zio.aws.networkfirewall.model.RuleOrder] =
      scala
        .Option(impl.ruleOrder())
        .map(value => zio.aws.networkfirewall.model.RuleOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.StatefulRuleOptions
  ): zio.aws.networkfirewall.model.StatefulRuleOptions.ReadOnly = new Wrapper(
    impl
  )
}
