package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.UpdateToken
import scala.jdk.CollectionConverters.*
final case class DescribeFirewallPolicyResponse(
    updateToken: UpdateToken,
    firewallPolicyResponse: zio.aws.networkfirewall.model.FirewallPolicyResponse,
    firewallPolicy: Option[zio.aws.networkfirewall.model.FirewallPolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyResponse = {
    import DescribeFirewallPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyResponse
      .builder()
      .updateToken(UpdateToken.unwrap(updateToken): java.lang.String)
      .firewallPolicyResponse(firewallPolicyResponse.buildAwsValue())
      .optionallyWith(firewallPolicy.map(value => value.buildAwsValue()))(
        _.firewallPolicy
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DescribeFirewallPolicyResponse.ReadOnly =
    zio.aws.networkfirewall.model.DescribeFirewallPolicyResponse
      .wrap(buildAwsValue())
}
object DescribeFirewallPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.DescribeFirewallPolicyResponse =
      zio.aws.networkfirewall.model.DescribeFirewallPolicyResponse(
        updateToken,
        firewallPolicyResponse.asEditable,
        firewallPolicy.map(value => value.asEditable)
      )
    def updateToken: UpdateToken
    def firewallPolicyResponse
        : zio.aws.networkfirewall.model.FirewallPolicyResponse.ReadOnly
    def firewallPolicy
        : Option[zio.aws.networkfirewall.model.FirewallPolicy.ReadOnly]
    def getUpdateToken: ZIO[Any, Nothing, UpdateToken] =
      ZIO.succeed(updateToken)
    def getFirewallPolicyResponse: ZIO[
      Any,
      Nothing,
      zio.aws.networkfirewall.model.FirewallPolicyResponse.ReadOnly
    ] = ZIO.succeed(firewallPolicyResponse)
    def getFirewallPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.FirewallPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("firewallPolicy", firewallPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyResponse
  ) extends zio.aws.networkfirewall.model.DescribeFirewallPolicyResponse.ReadOnly {
    override val updateToken: UpdateToken =
      zio.aws.networkfirewall.model.primitives.UpdateToken(impl.updateToken())
    override val firewallPolicyResponse
        : zio.aws.networkfirewall.model.FirewallPolicyResponse.ReadOnly =
      zio.aws.networkfirewall.model.FirewallPolicyResponse
        .wrap(impl.firewallPolicyResponse())
    override val firewallPolicy
        : Option[zio.aws.networkfirewall.model.FirewallPolicy.ReadOnly] = scala
      .Option(impl.firewallPolicy())
      .map(value => zio.aws.networkfirewall.model.FirewallPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyResponse
  ): zio.aws.networkfirewall.model.DescribeFirewallPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
