package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{ResourceArn, ResourceName}
import scala.jdk.CollectionConverters.*
final case class DescribeFirewallPolicyRequest(
    firewallPolicyName: Option[ResourceName] = None,
    firewallPolicyArn: Option[ResourceArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyRequest = {
    import DescribeFirewallPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyRequest
      .builder()
      .optionallyWith(
        firewallPolicyName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.firewallPolicyName)
      .optionallyWith(
        firewallPolicyArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.firewallPolicyArn)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DescribeFirewallPolicyRequest.ReadOnly =
    zio.aws.networkfirewall.model.DescribeFirewallPolicyRequest
      .wrap(buildAwsValue())
}
object DescribeFirewallPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.DescribeFirewallPolicyRequest =
      zio.aws.networkfirewall.model.DescribeFirewallPolicyRequest(
        firewallPolicyName.map(value => value),
        firewallPolicyArn.map(value => value)
      )
    def firewallPolicyName: Option[ResourceName]
    def firewallPolicyArn: Option[ResourceArn]
    def getFirewallPolicyName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallPolicyName", firewallPolicyName)
    def getFirewallPolicyArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallPolicyArn", firewallPolicyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyRequest
  ) extends zio.aws.networkfirewall.model.DescribeFirewallPolicyRequest.ReadOnly {
    override val firewallPolicyName: Option[ResourceName] = scala
      .Option(impl.firewallPolicyName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val firewallPolicyArn: Option[ResourceArn] = scala
      .Option(impl.firewallPolicyArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyRequest
  ): zio.aws.networkfirewall.model.DescribeFirewallPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
