package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{Description, ResourceName}
import scala.jdk.CollectionConverters._
final case class CreateTlsInspectionConfigurationRequest(
    tlsInspectionConfigurationName: ResourceName,
    tlsInspectionConfiguration: zio.aws.networkfirewall.model.TLSInspectionConfiguration,
    description: Optional[Description] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkfirewall.model.Tag]] =
      Optional.Absent,
    encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.CreateTlsInspectionConfigurationRequest = {
    import CreateTlsInspectionConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.CreateTlsInspectionConfigurationRequest
      .builder()
      .tlsInspectionConfigurationName(
        ResourceName.unwrap(tlsInspectionConfigurationName): java.lang.String
      )
      .tlsInspectionConfiguration(tlsInspectionConfiguration.buildAwsValue())
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.CreateTlsInspectionConfigurationRequest.ReadOnly =
    zio.aws.networkfirewall.model.CreateTlsInspectionConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateTlsInspectionConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.CreateTlsInspectionConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.CreateTlsInspectionConfigurationRequest =
      zio.aws.networkfirewall.model.CreateTlsInspectionConfigurationRequest(
        tlsInspectionConfigurationName,
        tlsInspectionConfiguration.asEditable,
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        encryptionConfiguration.map(value => value.asEditable)
      )
    def tlsInspectionConfigurationName: ResourceName
    def tlsInspectionConfiguration
        : zio.aws.networkfirewall.model.TLSInspectionConfiguration.ReadOnly
    def description: Optional[Description]
    def tags: Optional[List[zio.aws.networkfirewall.model.Tag.ReadOnly]]
    def encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ]
    def getTlsInspectionConfigurationName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(tlsInspectionConfigurationName)
    def getTlsInspectionConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.networkfirewall.model.TLSInspectionConfiguration.ReadOnly
    ] = ZIO.succeed(tlsInspectionConfiguration)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.CreateTlsInspectionConfigurationRequest
  ) extends zio.aws.networkfirewall.model.CreateTlsInspectionConfigurationRequest.ReadOnly {
    override val tlsInspectionConfigurationName: ResourceName =
      zio.aws.networkfirewall.model.primitives
        .ResourceName(impl.tlsInspectionConfigurationName())
    override val tlsInspectionConfiguration
        : zio.aws.networkfirewall.model.TLSInspectionConfiguration.ReadOnly =
      zio.aws.networkfirewall.model.TLSInspectionConfiguration
        .wrap(impl.tlsInspectionConfiguration())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.networkfirewall.model.primitives.Description(value))
    override val tags
        : Optional[List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.Tag.wrap(item)
          }.toList
        )
    override val encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionConfiguration())
      .map(value =>
        zio.aws.networkfirewall.model.EncryptionConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.CreateTlsInspectionConfigurationRequest
  ): zio.aws.networkfirewall.model.CreateTlsInspectionConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
