package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CheckCertificateRevocationStatusActions(
    revokedStatusAction: Optional[
      zio.aws.networkfirewall.model.RevocationCheckAction
    ] = Optional.Absent,
    unknownStatusAction: Optional[
      zio.aws.networkfirewall.model.RevocationCheckAction
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.CheckCertificateRevocationStatusActions = {
    import CheckCertificateRevocationStatusActions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.CheckCertificateRevocationStatusActions
      .builder()
      .optionallyWith(revokedStatusAction.map(value => value.unwrap))(
        _.revokedStatusAction
      )
      .optionallyWith(unknownStatusAction.map(value => value.unwrap))(
        _.unknownStatusAction
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.CheckCertificateRevocationStatusActions.ReadOnly =
    zio.aws.networkfirewall.model.CheckCertificateRevocationStatusActions
      .wrap(buildAwsValue())
}
object CheckCertificateRevocationStatusActions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.CheckCertificateRevocationStatusActions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.CheckCertificateRevocationStatusActions =
      zio.aws.networkfirewall.model.CheckCertificateRevocationStatusActions(
        revokedStatusAction.map(value => value),
        unknownStatusAction.map(value => value)
      )
    def revokedStatusAction
        : Optional[zio.aws.networkfirewall.model.RevocationCheckAction]
    def unknownStatusAction
        : Optional[zio.aws.networkfirewall.model.RevocationCheckAction]
    def getRevokedStatusAction: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.RevocationCheckAction
    ] = AwsError.unwrapOptionField("revokedStatusAction", revokedStatusAction)
    def getUnknownStatusAction: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.RevocationCheckAction
    ] = AwsError.unwrapOptionField("unknownStatusAction", unknownStatusAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.CheckCertificateRevocationStatusActions
  ) extends zio.aws.networkfirewall.model.CheckCertificateRevocationStatusActions.ReadOnly {
    override val revokedStatusAction
        : Optional[zio.aws.networkfirewall.model.RevocationCheckAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revokedStatusAction())
        .map(value =>
          zio.aws.networkfirewall.model.RevocationCheckAction.wrap(value)
        )
    override val unknownStatusAction
        : Optional[zio.aws.networkfirewall.model.RevocationCheckAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unknownStatusAction())
        .map(value =>
          zio.aws.networkfirewall.model.RevocationCheckAction.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.CheckCertificateRevocationStatusActions
  ): zio.aws.networkfirewall.model.CheckCertificateRevocationStatusActions.ReadOnly =
    new Wrapper(impl)
}
