package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{
  RulesString,
  UpdateToken,
  Description,
  ResourceArn,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class UpdateRuleGroupRequest(
    updateToken: UpdateToken,
    ruleGroupArn: Optional[ResourceArn] = Optional.Absent,
    ruleGroupName: Optional[ResourceName] = Optional.Absent,
    ruleGroup: Optional[zio.aws.networkfirewall.model.RuleGroup] =
      Optional.Absent,
    rules: Optional[RulesString] = Optional.Absent,
    `type`: Optional[zio.aws.networkfirewall.model.RuleGroupType] =
      Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration
    ] = Optional.Absent,
    sourceMetadata: Optional[zio.aws.networkfirewall.model.SourceMetadata] =
      Optional.Absent,
    analyzeRuleGroup: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupRequest = {
    import UpdateRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupRequest
      .builder()
      .updateToken(UpdateToken.unwrap(updateToken): java.lang.String)
      .optionallyWith(
        ruleGroupArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.ruleGroupArn)
      .optionallyWith(
        ruleGroupName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.ruleGroupName)
      .optionallyWith(ruleGroup.map(value => value.buildAwsValue()))(
        _.ruleGroup
      )
      .optionallyWith(
        rules.map(value => RulesString.unwrap(value): java.lang.String)
      )(_.rules)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .optionallyWith(sourceMetadata.map(value => value.buildAwsValue()))(
        _.sourceMetadata
      )
      .optionallyWith(analyzeRuleGroup.map(value => value: java.lang.Boolean))(
        _.analyzeRuleGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.UpdateRuleGroupRequest.ReadOnly =
    zio.aws.networkfirewall.model.UpdateRuleGroupRequest.wrap(buildAwsValue())
}
object UpdateRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.UpdateRuleGroupRequest =
      zio.aws.networkfirewall.model.UpdateRuleGroupRequest(
        updateToken,
        ruleGroupArn.map(value => value),
        ruleGroupName.map(value => value),
        ruleGroup.map(value => value.asEditable),
        rules.map(value => value),
        `type`.map(value => value),
        description.map(value => value),
        dryRun.map(value => value),
        encryptionConfiguration.map(value => value.asEditable),
        sourceMetadata.map(value => value.asEditable),
        analyzeRuleGroup.map(value => value)
      )
    def updateToken: UpdateToken
    def ruleGroupArn: Optional[ResourceArn]
    def ruleGroupName: Optional[ResourceName]
    def ruleGroup: Optional[zio.aws.networkfirewall.model.RuleGroup.ReadOnly]
    def rules: Optional[RulesString]
    def `type`: Optional[zio.aws.networkfirewall.model.RuleGroupType]
    def description: Optional[Description]
    def dryRun: Optional[Boolean]
    def encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ]
    def sourceMetadata
        : Optional[zio.aws.networkfirewall.model.SourceMetadata.ReadOnly]
    def analyzeRuleGroup: Optional[Boolean]
    def getUpdateToken: ZIO[Any, Nothing, UpdateToken] =
      ZIO.succeed(updateToken)
    def getRuleGroupArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("ruleGroupArn", ruleGroupArn)
    def getRuleGroupName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("ruleGroupName", ruleGroupName)
    def getRuleGroup
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.RuleGroup.ReadOnly] =
      AwsError.unwrapOptionField("ruleGroup", ruleGroup)
    def getRules: ZIO[Any, AwsError, RulesString] =
      AwsError.unwrapOptionField("rules", rules)
    def getType
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.RuleGroupType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
    def getSourceMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.SourceMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("sourceMetadata", sourceMetadata)
    def getAnalyzeRuleGroup: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("analyzeRuleGroup", analyzeRuleGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupRequest
  ) extends zio.aws.networkfirewall.model.UpdateRuleGroupRequest.ReadOnly {
    override val updateToken: UpdateToken =
      zio.aws.networkfirewall.model.primitives.UpdateToken(impl.updateToken())
    override val ruleGroupArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleGroupArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val ruleGroupName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleGroupName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val ruleGroup
        : Optional[zio.aws.networkfirewall.model.RuleGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleGroup())
        .map(value => zio.aws.networkfirewall.model.RuleGroup.wrap(value))
    override val rules: Optional[RulesString] = zio.aws.core.internal
      .optionalFromNullable(impl.rules())
      .map(value => zio.aws.networkfirewall.model.primitives.RulesString(value))
    override val `type`: Optional[zio.aws.networkfirewall.model.RuleGroupType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.networkfirewall.model.RuleGroupType.wrap(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.networkfirewall.model.primitives.Description(value))
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionConfiguration())
      .map(value =>
        zio.aws.networkfirewall.model.EncryptionConfiguration.wrap(value)
      )
    override val sourceMetadata
        : Optional[zio.aws.networkfirewall.model.SourceMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceMetadata())
        .map(value => zio.aws.networkfirewall.model.SourceMetadata.wrap(value))
    override val analyzeRuleGroup: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.analyzeRuleGroup())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupRequest
  ): zio.aws.networkfirewall.model.UpdateRuleGroupRequest.ReadOnly =
    new Wrapper(impl)
}
