package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class ServerCertificateConfiguration(
    serverCertificates: Optional[
      Iterable[zio.aws.networkfirewall.model.ServerCertificate]
    ] = Optional.Absent,
    scopes: Optional[
      Iterable[zio.aws.networkfirewall.model.ServerCertificateScope]
    ] = Optional.Absent,
    certificateAuthorityArn: Optional[ResourceArn] = Optional.Absent,
    checkCertificateRevocationStatus: Optional[
      zio.aws.networkfirewall.model.CheckCertificateRevocationStatusActions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.ServerCertificateConfiguration = {
    import ServerCertificateConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.ServerCertificateConfiguration
      .builder()
      .optionallyWith(
        serverCertificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serverCertificates)
      .optionallyWith(
        scopes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scopes)
      .optionallyWith(
        certificateAuthorityArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.certificateAuthorityArn)
      .optionallyWith(
        checkCertificateRevocationStatus.map(value => value.buildAwsValue())
      )(_.checkCertificateRevocationStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.ServerCertificateConfiguration.ReadOnly =
    zio.aws.networkfirewall.model.ServerCertificateConfiguration
      .wrap(buildAwsValue())
}
object ServerCertificateConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.ServerCertificateConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.ServerCertificateConfiguration =
      zio.aws.networkfirewall.model.ServerCertificateConfiguration(
        serverCertificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scopes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        certificateAuthorityArn.map(value => value),
        checkCertificateRevocationStatus.map(value => value.asEditable)
      )
    def serverCertificates: Optional[
      List[zio.aws.networkfirewall.model.ServerCertificate.ReadOnly]
    ]
    def scopes: Optional[
      List[zio.aws.networkfirewall.model.ServerCertificateScope.ReadOnly]
    ]
    def certificateAuthorityArn: Optional[ResourceArn]
    def checkCertificateRevocationStatus: Optional[
      zio.aws.networkfirewall.model.CheckCertificateRevocationStatusActions.ReadOnly
    ]
    def getServerCertificates: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.ServerCertificate.ReadOnly
    ]] = AwsError.unwrapOptionField("serverCertificates", serverCertificates)
    def getScopes: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.ServerCertificateScope.ReadOnly
    ]] = AwsError.unwrapOptionField("scopes", scopes)
    def getCertificateAuthorityArn: ZIO[Any, AwsError, ResourceArn] = AwsError
      .unwrapOptionField("certificateAuthorityArn", certificateAuthorityArn)
    def getCheckCertificateRevocationStatus: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.CheckCertificateRevocationStatusActions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "checkCertificateRevocationStatus",
      checkCertificateRevocationStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.ServerCertificateConfiguration
  ) extends zio.aws.networkfirewall.model.ServerCertificateConfiguration.ReadOnly {
    override val serverCertificates: Optional[
      List[zio.aws.networkfirewall.model.ServerCertificate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverCertificates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.ServerCertificate.wrap(item)
        }.toList
      )
    override val scopes: Optional[
      List[zio.aws.networkfirewall.model.ServerCertificateScope.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scopes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.ServerCertificateScope.wrap(item)
        }.toList
      )
    override val certificateAuthorityArn: Optional[ResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateAuthorityArn())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.ResourceArn(value)
        )
    override val checkCertificateRevocationStatus: Optional[
      zio.aws.networkfirewall.model.CheckCertificateRevocationStatusActions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.checkCertificateRevocationStatus())
      .map(value =>
        zio.aws.networkfirewall.model.CheckCertificateRevocationStatusActions
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.ServerCertificateConfiguration
  ): zio.aws.networkfirewall.model.ServerCertificateConfiguration.ReadOnly =
    new Wrapper(impl)
}
