package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters._
sealed trait TCPFlag {
  def unwrap: software.amazon.awssdk.services.networkfirewall.model.TCPFlag
}
object TCPFlag {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.TCPFlag
  ): zio.aws.networkfirewall.model.TCPFlag = value match {
    case software.amazon.awssdk.services.networkfirewall.model.TCPFlag.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.TCPFlag.FIN =>
      val r = FIN
      r
    case software.amazon.awssdk.services.networkfirewall.model.TCPFlag.SYN =>
      val r = SYN
      r
    case software.amazon.awssdk.services.networkfirewall.model.TCPFlag.RST =>
      val r = RST
      r
    case software.amazon.awssdk.services.networkfirewall.model.TCPFlag.PSH =>
      val r = PSH
      r
    case software.amazon.awssdk.services.networkfirewall.model.TCPFlag.ACK =>
      val r = ACK
      r
    case software.amazon.awssdk.services.networkfirewall.model.TCPFlag.URG =>
      val r = URG
      r
    case software.amazon.awssdk.services.networkfirewall.model.TCPFlag.ECE =>
      val r = ECE
      r
    case software.amazon.awssdk.services.networkfirewall.model.TCPFlag.CWR =>
      val r = CWR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.TCPFlag {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.TCPFlag =
      software.amazon.awssdk.services.networkfirewall.model.TCPFlag.UNKNOWN_TO_SDK_VERSION
  }
  case object FIN extends zio.aws.networkfirewall.model.TCPFlag {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.TCPFlag =
      software.amazon.awssdk.services.networkfirewall.model.TCPFlag.FIN
  }
  case object SYN extends zio.aws.networkfirewall.model.TCPFlag {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.TCPFlag =
      software.amazon.awssdk.services.networkfirewall.model.TCPFlag.SYN
  }
  case object RST extends zio.aws.networkfirewall.model.TCPFlag {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.TCPFlag =
      software.amazon.awssdk.services.networkfirewall.model.TCPFlag.RST
  }
  case object PSH extends zio.aws.networkfirewall.model.TCPFlag {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.TCPFlag =
      software.amazon.awssdk.services.networkfirewall.model.TCPFlag.PSH
  }
  case object ACK extends zio.aws.networkfirewall.model.TCPFlag {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.TCPFlag =
      software.amazon.awssdk.services.networkfirewall.model.TCPFlag.ACK
  }
  case object URG extends zio.aws.networkfirewall.model.TCPFlag {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.TCPFlag =
      software.amazon.awssdk.services.networkfirewall.model.TCPFlag.URG
  }
  case object ECE extends zio.aws.networkfirewall.model.TCPFlag {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.TCPFlag =
      software.amazon.awssdk.services.networkfirewall.model.TCPFlag.ECE
  }
  case object CWR extends zio.aws.networkfirewall.model.TCPFlag {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.TCPFlag =
      software.amazon.awssdk.services.networkfirewall.model.TCPFlag.CWR
  }
}
