package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{ResourceArn, ResourceName}
import scala.jdk.CollectionConverters._
final case class DescribeFirewallRequest(
    firewallName: Optional[ResourceName] = Optional.Absent,
    firewallArn: Optional[ResourceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallRequest = {
    import DescribeFirewallRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallRequest
      .builder()
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DescribeFirewallRequest.ReadOnly =
    zio.aws.networkfirewall.model.DescribeFirewallRequest.wrap(buildAwsValue())
}
object DescribeFirewallRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.DescribeFirewallRequest =
      zio.aws.networkfirewall.model.DescribeFirewallRequest(
        firewallName.map(value => value),
        firewallArn.map(value => value)
      )
    def firewallName: Optional[ResourceName]
    def firewallArn: Optional[ResourceArn]
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallRequest
  ) extends zio.aws.networkfirewall.model.DescribeFirewallRequest.ReadOnly {
    override val firewallName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val firewallArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallRequest
  ): zio.aws.networkfirewall.model.DescribeFirewallRequest.ReadOnly =
    new Wrapper(impl)
}
