package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.networkfirewall.model.primitives.UpdateToken
import scala.jdk.CollectionConverters._
final case class UpdateTlsInspectionConfigurationResponse(
    updateToken: UpdateToken,
    tlsInspectionConfigurationResponse: zio.aws.networkfirewall.model.TLSInspectionConfigurationResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationResponse = {
    import UpdateTlsInspectionConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationResponse
      .builder()
      .updateToken(UpdateToken.unwrap(updateToken): java.lang.String)
      .tlsInspectionConfigurationResponse(
        tlsInspectionConfigurationResponse.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.UpdateTlsInspectionConfigurationResponse.ReadOnly =
    zio.aws.networkfirewall.model.UpdateTlsInspectionConfigurationResponse
      .wrap(buildAwsValue())
}
object UpdateTlsInspectionConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.UpdateTlsInspectionConfigurationResponse =
      zio.aws.networkfirewall.model.UpdateTlsInspectionConfigurationResponse(
        updateToken,
        tlsInspectionConfigurationResponse.asEditable
      )
    def updateToken: UpdateToken
    def tlsInspectionConfigurationResponse
        : zio.aws.networkfirewall.model.TLSInspectionConfigurationResponse.ReadOnly
    def getUpdateToken: ZIO[Any, Nothing, UpdateToken] =
      ZIO.succeed(updateToken)
    def getTlsInspectionConfigurationResponse: ZIO[
      Any,
      Nothing,
      zio.aws.networkfirewall.model.TLSInspectionConfigurationResponse.ReadOnly
    ] = ZIO.succeed(tlsInspectionConfigurationResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationResponse
  ) extends zio.aws.networkfirewall.model.UpdateTlsInspectionConfigurationResponse.ReadOnly {
    override val updateToken: UpdateToken =
      zio.aws.networkfirewall.model.primitives.UpdateToken(impl.updateToken())
    override val tlsInspectionConfigurationResponse
        : zio.aws.networkfirewall.model.TLSInspectionConfigurationResponse.ReadOnly =
      zio.aws.networkfirewall.model.TLSInspectionConfigurationResponse
        .wrap(impl.tlsInspectionConfigurationResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationResponse
  ): zio.aws.networkfirewall.model.UpdateTlsInspectionConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
