package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{Description, ResourceName}
import scala.jdk.CollectionConverters._
final case class CreateFirewallPolicyRequest(
    firewallPolicyName: ResourceName,
    firewallPolicy: zio.aws.networkfirewall.model.FirewallPolicy,
    description: Optional[Description] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkfirewall.model.Tag]] =
      Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyRequest = {
    import CreateFirewallPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyRequest
      .builder()
      .firewallPolicyName(
        ResourceName.unwrap(firewallPolicyName): java.lang.String
      )
      .firewallPolicy(firewallPolicy.buildAwsValue())
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.CreateFirewallPolicyRequest.ReadOnly =
    zio.aws.networkfirewall.model.CreateFirewallPolicyRequest
      .wrap(buildAwsValue())
}
object CreateFirewallPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.CreateFirewallPolicyRequest =
      zio.aws.networkfirewall.model.CreateFirewallPolicyRequest(
        firewallPolicyName,
        firewallPolicy.asEditable,
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value),
        encryptionConfiguration.map(value => value.asEditable)
      )
    def firewallPolicyName: ResourceName
    def firewallPolicy: zio.aws.networkfirewall.model.FirewallPolicy.ReadOnly
    def description: Optional[Description]
    def tags: Optional[List[zio.aws.networkfirewall.model.Tag.ReadOnly]]
    def dryRun: Optional[Boolean]
    def encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ]
    def getFirewallPolicyName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(firewallPolicyName)
    def getFirewallPolicy: ZIO[
      Any,
      Nothing,
      zio.aws.networkfirewall.model.FirewallPolicy.ReadOnly
    ] = ZIO.succeed(firewallPolicy)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyRequest
  ) extends zio.aws.networkfirewall.model.CreateFirewallPolicyRequest.ReadOnly {
    override val firewallPolicyName: ResourceName =
      zio.aws.networkfirewall.model.primitives
        .ResourceName(impl.firewallPolicyName())
    override val firewallPolicy
        : zio.aws.networkfirewall.model.FirewallPolicy.ReadOnly =
      zio.aws.networkfirewall.model.FirewallPolicy.wrap(impl.firewallPolicy())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.networkfirewall.model.primitives.Description(value))
    override val tags
        : Optional[List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.Tag.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val encryptionConfiguration: Optional[
      zio.aws.networkfirewall.model.EncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionConfiguration())
      .map(value =>
        zio.aws.networkfirewall.model.EncryptionConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyRequest
  ): zio.aws.networkfirewall.model.CreateFirewallPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
