package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class IPSetReference(
    referenceArn: Optional[ResourceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.IPSetReference = {
    import IPSetReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.IPSetReference
      .builder()
      .optionallyWith(
        referenceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.referenceArn)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.IPSetReference.ReadOnly =
    zio.aws.networkfirewall.model.IPSetReference.wrap(buildAwsValue())
}
object IPSetReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.IPSetReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.IPSetReference =
      zio.aws.networkfirewall.model
        .IPSetReference(referenceArn.map(value => value))
    def referenceArn: Optional[ResourceArn]
    def getReferenceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("referenceArn", referenceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.IPSetReference
  ) extends zio.aws.networkfirewall.model.IPSetReference.ReadOnly {
    override val referenceArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.IPSetReference
  ): zio.aws.networkfirewall.model.IPSetReference.ReadOnly = new Wrapper(impl)
}
