package zio.aws.networkfirewall.model
import zio.aws.networkfirewall.model.primitives.ProtocolNumber
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ServerCertificateScope(
    sources: Optional[Iterable[zio.aws.networkfirewall.model.Address]] =
      Optional.Absent,
    destinations: Optional[Iterable[zio.aws.networkfirewall.model.Address]] =
      Optional.Absent,
    sourcePorts: Optional[Iterable[zio.aws.networkfirewall.model.PortRange]] =
      Optional.Absent,
    destinationPorts: Optional[
      Iterable[zio.aws.networkfirewall.model.PortRange]
    ] = Optional.Absent,
    protocols: Optional[Iterable[ProtocolNumber]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.ServerCertificateScope = {
    import ServerCertificateScope.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.ServerCertificateScope
      .builder()
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .optionallyWith(
        sourcePorts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourcePorts)
      .optionallyWith(
        destinationPorts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinationPorts)
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            ProtocolNumber.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.protocols)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.ServerCertificateScope.ReadOnly =
    zio.aws.networkfirewall.model.ServerCertificateScope.wrap(buildAwsValue())
}
object ServerCertificateScope {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.ServerCertificateScope
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.ServerCertificateScope =
      zio.aws.networkfirewall.model.ServerCertificateScope(
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        destinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourcePorts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        destinationPorts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        protocols.map(value => value)
      )
    def sources: Optional[List[zio.aws.networkfirewall.model.Address.ReadOnly]]
    def destinations
        : Optional[List[zio.aws.networkfirewall.model.Address.ReadOnly]]
    def sourcePorts
        : Optional[List[zio.aws.networkfirewall.model.PortRange.ReadOnly]]
    def destinationPorts
        : Optional[List[zio.aws.networkfirewall.model.PortRange.ReadOnly]]
    def protocols: Optional[List[ProtocolNumber]]
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.Address.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
    def getDestinations: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.Address.ReadOnly
    ]] = AwsError.unwrapOptionField("destinations", destinations)
    def getSourcePorts: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.PortRange.ReadOnly
    ]] = AwsError.unwrapOptionField("sourcePorts", sourcePorts)
    def getDestinationPorts: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.PortRange.ReadOnly
    ]] = AwsError.unwrapOptionField("destinationPorts", destinationPorts)
    def getProtocols: ZIO[Any, AwsError, List[ProtocolNumber]] =
      AwsError.unwrapOptionField("protocols", protocols)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.ServerCertificateScope
  ) extends zio.aws.networkfirewall.model.ServerCertificateScope.ReadOnly {
    override val sources
        : Optional[List[zio.aws.networkfirewall.model.Address.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.Address.wrap(item)
          }.toList
        )
    override val destinations
        : Optional[List[zio.aws.networkfirewall.model.Address.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.Address.wrap(item)
          }.toList
        )
    override val sourcePorts
        : Optional[List[zio.aws.networkfirewall.model.PortRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourcePorts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.PortRange.wrap(item)
          }.toList
        )
    override val destinationPorts
        : Optional[List[zio.aws.networkfirewall.model.PortRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPorts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.PortRange.wrap(item)
          }.toList
        )
    override val protocols: Optional[List[ProtocolNumber]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocols())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.primitives.ProtocolNumber(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.ServerCertificateScope
  ): zio.aws.networkfirewall.model.ServerCertificateScope.ReadOnly =
    new Wrapper(impl)
}
