package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.VariableDefinition
import scala.jdk.CollectionConverters._
final case class PortSet(
    definition: Optional[Iterable[VariableDefinition]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.PortSet = {
    import PortSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.PortSet
      .builder()
      .optionallyWith(
        definition.map(value =>
          value.map { item =>
            VariableDefinition.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.definition)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.PortSet.ReadOnly =
    zio.aws.networkfirewall.model.PortSet.wrap(buildAwsValue())
}
object PortSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.PortSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.PortSet =
      zio.aws.networkfirewall.model.PortSet(definition.map(value => value))
    def definition: Optional[List[VariableDefinition]]
    def getDefinition: ZIO[Any, AwsError, List[VariableDefinition]] =
      AwsError.unwrapOptionField("definition", definition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.PortSet
  ) extends zio.aws.networkfirewall.model.PortSet.ReadOnly {
    override val definition: Optional[List[VariableDefinition]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.definition())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.primitives.VariableDefinition(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.PortSet
  ): zio.aws.networkfirewall.model.PortSet.ReadOnly = new Wrapper(impl)
}
