package zio.aws.networkfirewall.model
import zio.aws.networkfirewall.model.primitives.{
  PaginationMaxResults,
  PaginationToken
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRuleGroupsRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[PaginationMaxResults] = Optional.Absent,
    scope: Optional[zio.aws.networkfirewall.model.ResourceManagedStatus] =
      Optional.Absent,
    managedType: Optional[zio.aws.networkfirewall.model.ResourceManagedType] =
      Optional.Absent,
    `type`: Optional[zio.aws.networkfirewall.model.RuleGroupType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest = {
    import ListRuleGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => PaginationMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(scope.map(value => value.unwrap))(_.scope)
      .optionallyWith(managedType.map(value => value.unwrap))(_.managedType)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.ListRuleGroupsRequest.ReadOnly =
    zio.aws.networkfirewall.model.ListRuleGroupsRequest.wrap(buildAwsValue())
}
object ListRuleGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.ListRuleGroupsRequest =
      zio.aws.networkfirewall.model.ListRuleGroupsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        scope.map(value => value),
        managedType.map(value => value),
        `type`.map(value => value)
      )
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[PaginationMaxResults]
    def scope: Optional[zio.aws.networkfirewall.model.ResourceManagedStatus]
    def managedType: Optional[zio.aws.networkfirewall.model.ResourceManagedType]
    def `type`: Optional[zio.aws.networkfirewall.model.RuleGroupType]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PaginationMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getScope: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.ResourceManagedStatus
    ] = AwsError.unwrapOptionField("scope", scope)
    def getManagedType: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.ResourceManagedType
    ] = AwsError.unwrapOptionField("managedType", managedType)
    def getType
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.RuleGroupType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest
  ) extends zio.aws.networkfirewall.model.ListRuleGroupsRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.PaginationToken(value)
      )
    override val maxResults: Optional[PaginationMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.networkfirewall.model.primitives.PaginationMaxResults(value)
        )
    override val scope
        : Optional[zio.aws.networkfirewall.model.ResourceManagedStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scope())
        .map(value =>
          zio.aws.networkfirewall.model.ResourceManagedStatus.wrap(value)
        )
    override val managedType
        : Optional[zio.aws.networkfirewall.model.ResourceManagedType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedType())
        .map(value =>
          zio.aws.networkfirewall.model.ResourceManagedType.wrap(value)
        )
    override val `type`: Optional[zio.aws.networkfirewall.model.RuleGroupType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.networkfirewall.model.RuleGroupType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest
  ): zio.aws.networkfirewall.model.ListRuleGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
