package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters._
sealed trait RuleGroupType {
  def unwrap
      : software.amazon.awssdk.services.networkfirewall.model.RuleGroupType
}
object RuleGroupType {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.RuleGroupType
  ): zio.aws.networkfirewall.model.RuleGroupType = value match {
    case software.amazon.awssdk.services.networkfirewall.model.RuleGroupType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.RuleGroupType.STATELESS =>
      val r = STATELESS
      r
    case software.amazon.awssdk.services.networkfirewall.model.RuleGroupType.STATEFUL =>
      val r = STATEFUL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.RuleGroupType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.RuleGroupType =
      software.amazon.awssdk.services.networkfirewall.model.RuleGroupType.UNKNOWN_TO_SDK_VERSION
  }
  case object STATELESS extends zio.aws.networkfirewall.model.RuleGroupType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.RuleGroupType =
      software.amazon.awssdk.services.networkfirewall.model.RuleGroupType.STATELESS
  }
  case object STATEFUL extends zio.aws.networkfirewall.model.RuleGroupType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.RuleGroupType =
      software.amazon.awssdk.services.networkfirewall.model.RuleGroupType.STATEFUL
  }
}
