package zio.aws.networkfirewall.model
import zio.aws.networkfirewall.model.primitives.CIDRCount
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class IPSetMetadata(
    resolvedCIDRCount: Optional[CIDRCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.IPSetMetadata = {
    import IPSetMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.IPSetMetadata
      .builder()
      .optionallyWith(
        resolvedCIDRCount.map(value => CIDRCount.unwrap(value): Integer)
      )(_.resolvedCIDRCount)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.IPSetMetadata.ReadOnly =
    zio.aws.networkfirewall.model.IPSetMetadata.wrap(buildAwsValue())
}
object IPSetMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.IPSetMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.IPSetMetadata =
      zio.aws.networkfirewall.model
        .IPSetMetadata(resolvedCIDRCount.map(value => value))
    def resolvedCIDRCount: Optional[CIDRCount]
    def getResolvedCIDRCount: ZIO[Any, AwsError, CIDRCount] =
      AwsError.unwrapOptionField("resolvedCIDRCount", resolvedCIDRCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.IPSetMetadata
  ) extends zio.aws.networkfirewall.model.IPSetMetadata.ReadOnly {
    override val resolvedCIDRCount: Optional[CIDRCount] = zio.aws.core.internal
      .optionalFromNullable(impl.resolvedCIDRCount())
      .map(value => zio.aws.networkfirewall.model.primitives.CIDRCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.IPSetMetadata
  ): zio.aws.networkfirewall.model.IPSetMetadata.ReadOnly = new Wrapper(impl)
}
