package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{ResourceName, ResourceArn}
import scala.jdk.CollectionConverters._
final case class UpdateLoggingConfigurationResponse(
    firewallArn: Optional[ResourceArn] = Optional.Absent,
    firewallName: Optional[ResourceName] = Optional.Absent,
    loggingConfiguration: Optional[
      zio.aws.networkfirewall.model.LoggingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationResponse = {
    import UpdateLoggingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationResponse
      .builder()
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.UpdateLoggingConfigurationResponse.ReadOnly =
    zio.aws.networkfirewall.model.UpdateLoggingConfigurationResponse
      .wrap(buildAwsValue())
}
object UpdateLoggingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.UpdateLoggingConfigurationResponse =
      zio.aws.networkfirewall.model.UpdateLoggingConfigurationResponse(
        firewallArn.map(value => value),
        firewallName.map(value => value),
        loggingConfiguration.map(value => value.asEditable)
      )
    def firewallArn: Optional[ResourceArn]
    def firewallName: Optional[ResourceName]
    def loggingConfiguration
        : Optional[zio.aws.networkfirewall.model.LoggingConfiguration.ReadOnly]
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.LoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationResponse
  ) extends zio.aws.networkfirewall.model.UpdateLoggingConfigurationResponse.ReadOnly {
    override val firewallArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val loggingConfiguration: Optional[
      zio.aws.networkfirewall.model.LoggingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingConfiguration())
      .map(value =>
        zio.aws.networkfirewall.model.LoggingConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationResponse
  ): zio.aws.networkfirewall.model.UpdateLoggingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
