package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{
  ResourceName,
  ResourceArn,
  UpdateToken
}
import scala.jdk.CollectionConverters._
final case class UpdateFirewallDeleteProtectionRequest(
    updateToken: Optional[UpdateToken] = Optional.Absent,
    firewallArn: Optional[ResourceArn] = Optional.Absent,
    firewallName: Optional[ResourceName] = Optional.Absent,
    deleteProtection: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionRequest = {
    import UpdateFirewallDeleteProtectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionRequest
      .builder()
      .optionallyWith(
        updateToken.map(value => UpdateToken.unwrap(value): java.lang.String)
      )(_.updateToken)
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .deleteProtection(deleteProtection: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionRequest.ReadOnly =
    zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionRequest
      .wrap(buildAwsValue())
}
object UpdateFirewallDeleteProtectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionRequest =
      zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionRequest(
        updateToken.map(value => value),
        firewallArn.map(value => value),
        firewallName.map(value => value),
        deleteProtection
      )
    def updateToken: Optional[UpdateToken]
    def firewallArn: Optional[ResourceArn]
    def firewallName: Optional[ResourceName]
    def deleteProtection: Boolean
    def getUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("updateToken", updateToken)
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getDeleteProtection: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(deleteProtection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionRequest
  ) extends zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionRequest.ReadOnly {
    override val updateToken: Optional[UpdateToken] = zio.aws.core.internal
      .optionalFromNullable(impl.updateToken())
      .map(value => zio.aws.networkfirewall.model.primitives.UpdateToken(value))
    override val firewallArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val deleteProtection: Boolean = impl.deleteProtection(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionRequest
  ): zio.aws.networkfirewall.model.UpdateFirewallDeleteProtectionRequest.ReadOnly =
    new Wrapper(impl)
}
