package zio.aws.networkfirewall.model
import zio.aws.networkfirewall.model.primitives.{Priority, ResourceArn}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StatefulRuleGroupReference(
    resourceArn: ResourceArn,
    priority: Optional[Priority] = Optional.Absent,
    `override`: Optional[
      zio.aws.networkfirewall.model.StatefulRuleGroupOverride
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.StatefulRuleGroupReference = {
    import StatefulRuleGroupReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.StatefulRuleGroupReference
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .optionallyWith(priority.map(value => Priority.unwrap(value): Integer))(
        _.priority
      )
      .optionallyWith(`override`.map(value => value.buildAwsValue()))(
        _.`override`
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.StatefulRuleGroupReference.ReadOnly =
    zio.aws.networkfirewall.model.StatefulRuleGroupReference
      .wrap(buildAwsValue())
}
object StatefulRuleGroupReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.StatefulRuleGroupReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.StatefulRuleGroupReference =
      zio.aws.networkfirewall.model.StatefulRuleGroupReference(
        resourceArn,
        priority.map(value => value),
        `override`.map(value => value.asEditable)
      )
    def resourceArn: ResourceArn
    def priority: Optional[Priority]
    def `override`: Optional[
      zio.aws.networkfirewall.model.StatefulRuleGroupOverride.ReadOnly
    ]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getPriority: ZIO[Any, AwsError, Priority] =
      AwsError.unwrapOptionField("priority", priority)
    def getOverride: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.StatefulRuleGroupOverride.ReadOnly
    ] = AwsError.unwrapOptionField("override", `override`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.StatefulRuleGroupReference
  ) extends zio.aws.networkfirewall.model.StatefulRuleGroupReference.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.networkfirewall.model.primitives.ResourceArn(impl.resourceArn())
    override val priority: Optional[Priority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.networkfirewall.model.primitives.Priority(value))
    override val `override`: Optional[
      zio.aws.networkfirewall.model.StatefulRuleGroupOverride.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.`override`())
      .map(value =>
        zio.aws.networkfirewall.model.StatefulRuleGroupOverride.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.StatefulRuleGroupReference
  ): zio.aws.networkfirewall.model.StatefulRuleGroupReference.ReadOnly =
    new Wrapper(impl)
}
