package zio.aws.networkfirewall
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.networkfirewall.model.primitives.{
  VpcId,
  AzSubnet,
  Setting,
  AvailabilityZone,
  ProtocolNumber,
  VariableDefinition,
  HashMapValue,
  RuleVariableName,
  CollectionMember_String,
  HashMapKey,
  ResourceName,
  TagKey
}
import zio.aws.networkfirewall.model.primitives.RuleCapacity.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ActionName extends Subtype[String]
    type ActionName = zio.aws.networkfirewall.model.primitives.ActionName.Type
    object AddressDefinition extends Subtype[String]
    type AddressDefinition =
      zio.aws.networkfirewall.model.primitives.AddressDefinition.Type
    object AvailabilityZone extends Subtype[String]
    type AvailabilityZone =
      zio.aws.networkfirewall.model.primitives.AvailabilityZone.Type
    object AzSubnet extends Subtype[String]
    type AzSubnet = zio.aws.networkfirewall.model.primitives.AzSubnet.Type
    object CollectionMember_String extends Subtype[String]
    type CollectionMember_String =
      zio.aws.networkfirewall.model.primitives.CollectionMember_String.Type
    object Description extends Subtype[String]
    type Description = zio.aws.networkfirewall.model.primitives.Description.Type
    object Destination extends Subtype[String]
    type Destination = zio.aws.networkfirewall.model.primitives.Destination.Type
    object DimensionValue extends Subtype[String]
    type DimensionValue =
      zio.aws.networkfirewall.model.primitives.DimensionValue.Type
    object EndpointId extends Subtype[String]
    type EndpointId = zio.aws.networkfirewall.model.primitives.EndpointId.Type
    object HashMapKey extends Subtype[String]
    type HashMapKey = zio.aws.networkfirewall.model.primitives.HashMapKey.Type
    object HashMapValue extends Subtype[String]
    type HashMapValue =
      zio.aws.networkfirewall.model.primitives.HashMapValue.Type
    object KeyId extends Subtype[String]
    type KeyId = zio.aws.networkfirewall.model.primitives.KeyId.Type
    object Keyword extends Subtype[String]
    type Keyword = zio.aws.networkfirewall.model.primitives.Keyword.Type
    object LastUpdateTime extends Subtype[Instant]
    type LastUpdateTime =
      zio.aws.networkfirewall.model.primitives.LastUpdateTime.Type
    object NumberOfAssociations extends Subtype[Int]
    type NumberOfAssociations =
      zio.aws.networkfirewall.model.primitives.NumberOfAssociations.Type
    object PaginationMaxResults extends Subtype[Int]
    type PaginationMaxResults =
      zio.aws.networkfirewall.model.primitives.PaginationMaxResults.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.networkfirewall.model.primitives.PaginationToken.Type
    object PolicyString extends Subtype[String]
    type PolicyString =
      zio.aws.networkfirewall.model.primitives.PolicyString.Type
    object Port extends Subtype[String]
    type Port = zio.aws.networkfirewall.model.primitives.Port.Type
    object PortRangeBound extends Subtype[Int]
    type PortRangeBound =
      zio.aws.networkfirewall.model.primitives.PortRangeBound.Type
    object Priority extends Subtype[Int]
    type Priority = zio.aws.networkfirewall.model.primitives.Priority.Type
    object ProtocolNumber extends Subtype[Int]
    type ProtocolNumber =
      zio.aws.networkfirewall.model.primitives.ProtocolNumber.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.networkfirewall.model.primitives.ResourceArn.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.networkfirewall.model.primitives.ResourceId.Type
    object ResourceName extends Subtype[String]
    type ResourceName =
      zio.aws.networkfirewall.model.primitives.ResourceName.Type
    object RuleCapacity extends Subtype[Int]
    type RuleCapacity =
      zio.aws.networkfirewall.model.primitives.RuleCapacity.Type
    object RuleVariableName extends Subtype[String]
    type RuleVariableName =
      zio.aws.networkfirewall.model.primitives.RuleVariableName.Type
    object RulesString extends Subtype[String]
    type RulesString = zio.aws.networkfirewall.model.primitives.RulesString.Type
    object Setting extends Subtype[String]
    type Setting = zio.aws.networkfirewall.model.primitives.Setting.Type
    object Source extends Subtype[String]
    type Source = zio.aws.networkfirewall.model.primitives.Source.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.networkfirewall.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.networkfirewall.model.primitives.TagValue.Type
    object TagsPaginationMaxResults extends Subtype[Int]
    type TagsPaginationMaxResults =
      zio.aws.networkfirewall.model.primitives.TagsPaginationMaxResults.Type
    object UpdateToken extends Subtype[String]
    type UpdateToken = zio.aws.networkfirewall.model.primitives.UpdateToken.Type
    object VariableDefinition extends Subtype[String]
    type VariableDefinition =
      zio.aws.networkfirewall.model.primitives.VariableDefinition.Type
    object VpcId extends Subtype[String]
    type VpcId = zio.aws.networkfirewall.model.primitives.VpcId.Type
  }
  type Addresses = List[zio.aws.networkfirewall.model.Address]
  type AzSubnets = List[AzSubnet]
  type CustomActions = List[zio.aws.networkfirewall.model.CustomAction]
  type Dimensions = List[zio.aws.networkfirewall.model.Dimension]
  type FirewallPolicies =
    List[zio.aws.networkfirewall.model.FirewallPolicyMetadata]
  type Firewalls = List[zio.aws.networkfirewall.model.FirewallMetadata]
  type Flags = List[zio.aws.networkfirewall.model.TCPFlag]
  type IPSets = Map[RuleVariableName, zio.aws.networkfirewall.model.IPSet]
  type LogDestinationConfigs =
    List[zio.aws.networkfirewall.model.LogDestinationConfig]
  type LogDestinationMap = Map[HashMapKey, HashMapValue]
  type PortRanges = List[zio.aws.networkfirewall.model.PortRange]
  type PortSets = Map[RuleVariableName, zio.aws.networkfirewall.model.PortSet]
  type ProtocolNumbers = List[ProtocolNumber]
  type RuleGroups = List[zio.aws.networkfirewall.model.RuleGroupMetadata]
  type RuleOptions = List[zio.aws.networkfirewall.model.RuleOption]
  type RuleTargets = List[CollectionMember_String]
  type Settings = List[Setting]
  type StatefulActions = List[CollectionMember_String]
  type StatefulRuleGroupReferences =
    List[zio.aws.networkfirewall.model.StatefulRuleGroupReference]
  type StatefulRules = List[zio.aws.networkfirewall.model.StatefulRule]
  type StatelessActions = List[CollectionMember_String]
  type StatelessRuleGroupReferences =
    List[zio.aws.networkfirewall.model.StatelessRuleGroupReference]
  type StatelessRules = List[zio.aws.networkfirewall.model.StatelessRule]
  type SubnetMappings = List[zio.aws.networkfirewall.model.SubnetMapping]
  type SyncStateConfig =
    Map[ResourceName, zio.aws.networkfirewall.model.PerObjectStatus]
  type SyncStates =
    Map[AvailabilityZone, zio.aws.networkfirewall.model.SyncState]
  type TCPFlags = List[zio.aws.networkfirewall.model.TCPFlagField]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.networkfirewall.model.Tag]
  type TargetTypes = List[zio.aws.networkfirewall.model.TargetType]
  type VariableDefinitionList = List[VariableDefinition]
  type VpcIds = List[VpcId]
}
