package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListFirewallsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    firewalls: Optional[
      Iterable[zio.aws.networkfirewall.model.FirewallMetadata]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse = {
    import ListFirewallsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        firewalls.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.firewalls)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.ListFirewallsResponse.ReadOnly =
    zio.aws.networkfirewall.model.ListFirewallsResponse.wrap(buildAwsValue())
}
object ListFirewallsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.ListFirewallsResponse =
      zio.aws.networkfirewall.model.ListFirewallsResponse(
        nextToken.map(value => value),
        firewalls.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def firewalls: Optional[
      List[zio.aws.networkfirewall.model.FirewallMetadata.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFirewalls: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.FirewallMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("firewalls", firewalls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse
  ) extends zio.aws.networkfirewall.model.ListFirewallsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.PaginationToken(value)
      )
    override val firewalls: Optional[
      List[zio.aws.networkfirewall.model.FirewallMetadata.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.firewalls())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.FirewallMetadata.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse
  ): zio.aws.networkfirewall.model.ListFirewallsResponse.ReadOnly = new Wrapper(
    impl
  )
}
