package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.{
  ResourceName,
  ResourceArn,
  UpdateToken
}
import scala.jdk.CollectionConverters._
final case class UpdateSubnetChangeProtectionResponse(
    updateToken: Optional[UpdateToken] = Optional.Absent,
    firewallArn: Optional[ResourceArn] = Optional.Absent,
    firewallName: Optional[ResourceName] = Optional.Absent,
    subnetChangeProtection: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionResponse = {
    import UpdateSubnetChangeProtectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionResponse
      .builder()
      .optionallyWith(
        updateToken.map(value => UpdateToken.unwrap(value): java.lang.String)
      )(_.updateToken)
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .optionallyWith(
        subnetChangeProtection.map(value => value: java.lang.Boolean)
      )(_.subnetChangeProtection)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionResponse.ReadOnly =
    zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionResponse
      .wrap(buildAwsValue())
}
object UpdateSubnetChangeProtectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionResponse =
      zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionResponse(
        updateToken.map(value => value),
        firewallArn.map(value => value),
        firewallName.map(value => value),
        subnetChangeProtection.map(value => value)
      )
    def updateToken: Optional[UpdateToken]
    def firewallArn: Optional[ResourceArn]
    def firewallName: Optional[ResourceName]
    def subnetChangeProtection: Optional[Boolean]
    def getUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("updateToken", updateToken)
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getSubnetChangeProtection: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("subnetChangeProtection", subnetChangeProtection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionResponse
  ) extends zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionResponse.ReadOnly {
    override val updateToken: Optional[UpdateToken] = zio.aws.core.internal
      .optionalFromNullable(impl.updateToken())
      .map(value => zio.aws.networkfirewall.model.primitives.UpdateToken(value))
    override val firewallArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val subnetChangeProtection: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetChangeProtection())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionResponse
  ): zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionResponse.ReadOnly =
    new Wrapper(impl)
}
