package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters._
sealed trait ResourceManagedType {
  def unwrap: software.amazon.awssdk.services.networkfirewall.model.ResourceManagedType
}
object ResourceManagedType {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.ResourceManagedType
  ): zio.aws.networkfirewall.model.ResourceManagedType = value match {
    case software.amazon.awssdk.services.networkfirewall.model.ResourceManagedType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.ResourceManagedType.AWS_MANAGED_THREAT_SIGNATURES =>
      val r = AWS_MANAGED_THREAT_SIGNATURES
      r
    case software.amazon.awssdk.services.networkfirewall.model.ResourceManagedType.AWS_MANAGED_DOMAIN_LISTS =>
      val r = AWS_MANAGED_DOMAIN_LISTS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.ResourceManagedType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.ResourceManagedType =
      software.amazon.awssdk.services.networkfirewall.model.ResourceManagedType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_MANAGED_THREAT_SIGNATURES
      extends zio.aws.networkfirewall.model.ResourceManagedType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.ResourceManagedType =
      software.amazon.awssdk.services.networkfirewall.model.ResourceManagedType.AWS_MANAGED_THREAT_SIGNATURES
  }
  case object AWS_MANAGED_DOMAIN_LISTS
      extends zio.aws.networkfirewall.model.ResourceManagedType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.ResourceManagedType =
      software.amazon.awssdk.services.networkfirewall.model.ResourceManagedType.AWS_MANAGED_DOMAIN_LISTS
  }
}
