package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.networkfirewall.model.primitives.VariableDefinition
import scala.jdk.CollectionConverters._
final case class IPSet(definition: Iterable[VariableDefinition]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.IPSet = {
    import IPSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.IPSet
      .builder()
      .definition(definition.map { item =>
        VariableDefinition.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.IPSet.ReadOnly =
    zio.aws.networkfirewall.model.IPSet.wrap(buildAwsValue())
}
object IPSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.IPSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.IPSet =
      zio.aws.networkfirewall.model.IPSet(definition)
    def definition: List[VariableDefinition]
    def getDefinition: ZIO[Any, Nothing, List[VariableDefinition]] =
      ZIO.succeed(definition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.IPSet
  ) extends zio.aws.networkfirewall.model.IPSet.ReadOnly {
    override val definition: List[VariableDefinition] = impl
      .definition()
      .asScala
      .map { item =>
        zio.aws.networkfirewall.model.primitives.VariableDefinition(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.IPSet
  ): zio.aws.networkfirewall.model.IPSet.ReadOnly = new Wrapper(impl)
}
