package zio.aws.networkfirewall.model
import zio.aws.networkfirewall.model.primitives.{
  RuleCapacity,
  Description,
  RulesString,
  ResourceName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateRuleGroupRequest(
    ruleGroupName: ResourceName,
    ruleGroup: Optional[zio.aws.networkfirewall.model.RuleGroup] =
      Optional.Absent,
    rules: Optional[RulesString] = Optional.Absent,
    `type`: zio.aws.networkfirewall.model.RuleGroupType,
    description: Optional[Description] = Optional.Absent,
    capacity: RuleCapacity,
    tags: Optional[Iterable[zio.aws.networkfirewall.model.Tag]] =
      Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupRequest = {
    import CreateRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupRequest
      .builder()
      .ruleGroupName(ResourceName.unwrap(ruleGroupName): java.lang.String)
      .optionallyWith(ruleGroup.map(value => value.buildAwsValue()))(
        _.ruleGroup
      )
      .optionallyWith(
        rules.map(value => RulesString.unwrap(value): java.lang.String)
      )(_.rules)
      .`type`(`type`.unwrap)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .capacity(RuleCapacity.unwrap(capacity): Integer)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.CreateRuleGroupRequest.ReadOnly =
    zio.aws.networkfirewall.model.CreateRuleGroupRequest.wrap(buildAwsValue())
}
object CreateRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.CreateRuleGroupRequest =
      zio.aws.networkfirewall.model.CreateRuleGroupRequest(
        ruleGroupName,
        ruleGroup.map(value => value.asEditable),
        rules.map(value => value),
        `type`,
        description.map(value => value),
        capacity,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value)
      )
    def ruleGroupName: ResourceName
    def ruleGroup: Optional[zio.aws.networkfirewall.model.RuleGroup.ReadOnly]
    def rules: Optional[RulesString]
    def `type`: zio.aws.networkfirewall.model.RuleGroupType
    def description: Optional[Description]
    def capacity: RuleCapacity
    def tags: Optional[List[zio.aws.networkfirewall.model.Tag.ReadOnly]]
    def dryRun: Optional[Boolean]
    def getRuleGroupName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(ruleGroupName)
    def getRuleGroup
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.RuleGroup.ReadOnly] =
      AwsError.unwrapOptionField("ruleGroup", ruleGroup)
    def getRules: ZIO[Any, AwsError, RulesString] =
      AwsError.unwrapOptionField("rules", rules)
    def getType
        : ZIO[Any, Nothing, zio.aws.networkfirewall.model.RuleGroupType] =
      ZIO.succeed(`type`)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCapacity: ZIO[Any, Nothing, RuleCapacity] = ZIO.succeed(capacity)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupRequest
  ) extends zio.aws.networkfirewall.model.CreateRuleGroupRequest.ReadOnly {
    override val ruleGroupName: ResourceName =
      zio.aws.networkfirewall.model.primitives
        .ResourceName(impl.ruleGroupName())
    override val ruleGroup
        : Optional[zio.aws.networkfirewall.model.RuleGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleGroup())
        .map(value => zio.aws.networkfirewall.model.RuleGroup.wrap(value))
    override val rules: Optional[RulesString] = zio.aws.core.internal
      .optionalFromNullable(impl.rules())
      .map(value => zio.aws.networkfirewall.model.primitives.RulesString(value))
    override val `type`: zio.aws.networkfirewall.model.RuleGroupType =
      zio.aws.networkfirewall.model.RuleGroupType.wrap(impl.`type`())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.networkfirewall.model.primitives.Description(value))
    override val capacity: RuleCapacity =
      zio.aws.networkfirewall.model.primitives.RuleCapacity(impl.capacity())
    override val tags
        : Optional[List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.Tag.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupRequest
  ): zio.aws.networkfirewall.model.CreateRuleGroupRequest.ReadOnly =
    new Wrapper(impl)
}
