package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.networkfirewall.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListRuleGroupsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    ruleGroups: Optional[
      Iterable[zio.aws.networkfirewall.model.RuleGroupMetadata]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse = {
    import ListRuleGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        ruleGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ruleGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.ListRuleGroupsResponse.ReadOnly =
    zio.aws.networkfirewall.model.ListRuleGroupsResponse.wrap(buildAwsValue())
}
object ListRuleGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.ListRuleGroupsResponse =
      zio.aws.networkfirewall.model.ListRuleGroupsResponse(
        nextToken.map(value => value),
        ruleGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def ruleGroups: Optional[
      List[zio.aws.networkfirewall.model.RuleGroupMetadata.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRuleGroups: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.RuleGroupMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("ruleGroups", ruleGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse
  ) extends zio.aws.networkfirewall.model.ListRuleGroupsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.PaginationToken(value)
      )
    override val ruleGroups: Optional[
      List[zio.aws.networkfirewall.model.RuleGroupMetadata.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.RuleGroupMetadata.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse
  ): zio.aws.networkfirewall.model.ListRuleGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
