package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{ResourceName, ResourceArn}
import scala.jdk.CollectionConverters._
final case class DescribeLoggingConfigurationRequest(
    firewallArn: Option[ResourceArn] = None,
    firewallName: Option[ResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationRequest = {
    import DescribeLoggingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationRequest
      .builder()
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DescribeLoggingConfigurationRequest.ReadOnly =
    zio.aws.networkfirewall.model.DescribeLoggingConfigurationRequest
      .wrap(buildAwsValue())
}
object DescribeLoggingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.DescribeLoggingConfigurationRequest =
      zio.aws.networkfirewall.model.DescribeLoggingConfigurationRequest(
        firewallArn.map(value => value),
        firewallName.map(value => value)
      )
    def firewallArn: Option[ResourceArn]
    def firewallName: Option[ResourceName]
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationRequest
  ) extends zio.aws.networkfirewall.model.DescribeLoggingConfigurationRequest.ReadOnly {
    override val firewallArn: Option[ResourceArn] = scala
      .Option(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallName: Option[ResourceName] = scala
      .Option(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationRequest
  ): zio.aws.networkfirewall.model.DescribeLoggingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
