package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{
  ResourceName,
  ResourceArn,
  UpdateToken
}
import scala.jdk.CollectionConverters._
final case class UpdateSubnetChangeProtectionRequest(
    updateToken: Option[UpdateToken] = None,
    firewallArn: Option[ResourceArn] = None,
    firewallName: Option[ResourceName] = None,
    subnetChangeProtection: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionRequest = {
    import UpdateSubnetChangeProtectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionRequest
      .builder()
      .optionallyWith(
        updateToken.map(value => UpdateToken.unwrap(value): java.lang.String)
      )(_.updateToken)
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .subnetChangeProtection(subnetChangeProtection: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionRequest.ReadOnly =
    zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionRequest
      .wrap(buildAwsValue())
}
object UpdateSubnetChangeProtectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionRequest =
      zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionRequest(
        updateToken.map(value => value),
        firewallArn.map(value => value),
        firewallName.map(value => value),
        subnetChangeProtection
      )
    def updateToken: Option[UpdateToken]
    def firewallArn: Option[ResourceArn]
    def firewallName: Option[ResourceName]
    def subnetChangeProtection: Boolean
    def getUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("updateToken", updateToken)
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getSubnetChangeProtection: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(subnetChangeProtection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionRequest
  ) extends zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionRequest.ReadOnly {
    override val updateToken: Option[UpdateToken] = scala
      .Option(impl.updateToken())
      .map(value => zio.aws.networkfirewall.model.primitives.UpdateToken(value))
    override val firewallArn: Option[ResourceArn] = scala
      .Option(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallName: Option[ResourceName] = scala
      .Option(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val subnetChangeProtection: Boolean =
      impl.subnetChangeProtection(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionRequest
  ): zio.aws.networkfirewall.model.UpdateSubnetChangeProtectionRequest.ReadOnly =
    new Wrapper(impl)
}
