package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StatelessRulesAndCustomActions(
    statelessRules: Iterable[zio.aws.networkfirewall.model.StatelessRule],
    customActions: Option[
      Iterable[zio.aws.networkfirewall.model.CustomAction]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.StatelessRulesAndCustomActions = {
    import StatelessRulesAndCustomActions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.StatelessRulesAndCustomActions
      .builder()
      .statelessRules(statelessRules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        customActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customActions)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.StatelessRulesAndCustomActions.ReadOnly =
    zio.aws.networkfirewall.model.StatelessRulesAndCustomActions
      .wrap(buildAwsValue())
}
object StatelessRulesAndCustomActions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.StatelessRulesAndCustomActions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.StatelessRulesAndCustomActions =
      zio.aws.networkfirewall.model.StatelessRulesAndCustomActions(
        statelessRules.map { item =>
          item.asEditable
        },
        customActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def statelessRules
        : List[zio.aws.networkfirewall.model.StatelessRule.ReadOnly]
    def customActions
        : Option[List[zio.aws.networkfirewall.model.CustomAction.ReadOnly]]
    def getStatelessRules: ZIO[Any, Nothing, List[
      zio.aws.networkfirewall.model.StatelessRule.ReadOnly
    ]] = ZIO.succeed(statelessRules)
    def getCustomActions: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.CustomAction.ReadOnly
    ]] = AwsError.unwrapOptionField("customActions", customActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.StatelessRulesAndCustomActions
  ) extends zio.aws.networkfirewall.model.StatelessRulesAndCustomActions.ReadOnly {
    override val statelessRules
        : List[zio.aws.networkfirewall.model.StatelessRule.ReadOnly] = impl
      .statelessRules()
      .asScala
      .map { item =>
        zio.aws.networkfirewall.model.StatelessRule.wrap(item)
      }
      .toList
    override val customActions
        : Option[List[zio.aws.networkfirewall.model.CustomAction.ReadOnly]] =
      scala
        .Option(impl.customActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.CustomAction.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.StatelessRulesAndCustomActions
  ): zio.aws.networkfirewall.model.StatelessRulesAndCustomActions.ReadOnly =
    new Wrapper(impl)
}
