package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{
  UpdateToken,
  ResourceName,
  ResourceArn
}
import scala.jdk.CollectionConverters._
final case class AssociateFirewallPolicyResponse(
    firewallArn: Option[ResourceArn] = None,
    firewallName: Option[ResourceName] = None,
    firewallPolicyArn: Option[ResourceArn] = None,
    updateToken: Option[UpdateToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyResponse = {
    import AssociateFirewallPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyResponse
      .builder()
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .optionallyWith(
        firewallPolicyArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.firewallPolicyArn)
      .optionallyWith(
        updateToken.map(value => UpdateToken.unwrap(value): java.lang.String)
      )(_.updateToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.AssociateFirewallPolicyResponse.ReadOnly =
    zio.aws.networkfirewall.model.AssociateFirewallPolicyResponse
      .wrap(buildAwsValue())
}
object AssociateFirewallPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.AssociateFirewallPolicyResponse =
      zio.aws.networkfirewall.model.AssociateFirewallPolicyResponse(
        firewallArn.map(value => value),
        firewallName.map(value => value),
        firewallPolicyArn.map(value => value),
        updateToken.map(value => value)
      )
    def firewallArn: Option[ResourceArn]
    def firewallName: Option[ResourceName]
    def firewallPolicyArn: Option[ResourceArn]
    def updateToken: Option[UpdateToken]
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getFirewallPolicyArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallPolicyArn", firewallPolicyArn)
    def getUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("updateToken", updateToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyResponse
  ) extends zio.aws.networkfirewall.model.AssociateFirewallPolicyResponse.ReadOnly {
    override val firewallArn: Option[ResourceArn] = scala
      .Option(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallName: Option[ResourceName] = scala
      .Option(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val firewallPolicyArn: Option[ResourceArn] = scala
      .Option(impl.firewallPolicyArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val updateToken: Option[UpdateToken] = scala
      .Option(impl.updateToken())
      .map(value => zio.aws.networkfirewall.model.primitives.UpdateToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyResponse
  ): zio.aws.networkfirewall.model.AssociateFirewallPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
